/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hdb.dcn.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Packer;
import kd.ebg.aqap.banks.hdb.dcn.services.utils.Signature;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public void configFactory(ConnectionFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append("/linkbank/");
        sb.append(this.getBizCode());
        sb.append(".do");
        factory.setUri(sb.toString());
        factory.setHttpHeader("signature", RequestContextUtils.getRunningParam((String)"sign"));
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.packCommHeader();
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        Element listElement = JDomUtils.addChild((Element)body, (String)"linkReqList");
        JDomUtils.addChild((Element)listElement, (String)"transFlowNo", (String)paymentInfo.getBankRefID());
        String data = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        String sign = Signature.getInstance().sign(data, this.getBizCode());
        RequestContextUtils.setRunningParam((String)"sign", (String)sign);
        return data;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = root.getChild("body");
        Element mapElement = body.getChild("linkRespList");
        String errorCode = mapElement.getChildTextTrim("errorCode");
        String errorMsg = mapElement.getChildTextTrim("errorMsg");
        String transStatus = mapElement.getChildTextTrim("transStatus");
        String transFlowNo = mapElement.getChildTextTrim("transFlowNo");
        if (!"0".equals(errorCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]), (String)errorCode, (String)errorMsg);
        } else if (StringUtils.isNotEmpty((String)transFlowNo) && transFlowNo.equals(paymentInfo.getBankRefID())) {
            if ("0".equals(transStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]), (String)transStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]));
            } else if ("1".equals(transStatus)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]), (String)transStatus, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]), (String)transStatus, (String)errorMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]), (String)transStatus, (String)ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u72b6\u6001\u94f6\u884c\u8fd4\u56detransFlowNo\u4e3a\u7a7a\u6216\u8005\u5339\u914d\u4e0d\u4e0a\uff0c\u8bf7\u4eba\u5de5\u786e\u8ba4\u72b6\u6001\u3002", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "LB00019";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u8f6c\u8d26\u72b6\u6001\u67e5\u8be2", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-hdb-dcn", (Object[])new Object[0]);
    }
}

