/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.oversea;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.payment.oversea.b2e0705Impl;
import kd.ebg.aqap.business.file.AbstractAttachmentImpl;
import kd.ebg.aqap.business.payment.bank.BankAttachmentRequest;
import kd.ebg.aqap.business.payment.bank.BankAttachmentResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PaymentInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBPayUnknownException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.io.FileUtils;
import org.jdom2.Element;
import org.slf4j.MDC;

public class AttachmentUploadImpl
extends AbstractAttachmentImpl {
    private long maxFileSize = 0xA00000L;
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public String pack(PayAttachment payAttachment) {
        String payImplClassName;
        Element root = BocNetUtils.createRoot();
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
        JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
        JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
        JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
        JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0706");
        JDomUtils.addChild((Element)head, (String)"token", (String)"");
        Element trans = JDomUtils.addChild((Element)root, (String)"trans");
        Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0706-rq");
        Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0706-rq");
        JDomUtils.addChild((Element)rq, (String)"obssid", (String)payAttachment.getBankRefID());
        String screenagetranstype = "1";
        Map runningParams = EBContext.getContext().getRunningParams();
        if (runningParams != null && "kd.ebg.aqap.banks.boc.net.service.payment.company.fcurrency.FCurrencyPayImpl".equalsIgnoreCase(payImplClassName = (String)runningParams.get("payImplClassName"))) {
            screenagetranstype = "4";
        }
        JDomUtils.addChild((Element)rq, (String)"screenagetranstype", (String)screenagetranstype);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public void parse(PayAttachment payAttachment, String response) {
    }

    public BankAttachmentResponse doBiz(BankAttachmentRequest bankAttachmentRequest) {
        List attachments = bankAttachmentRequest.getPayAttachments();
        if (CollectionUtil.isEmpty((Collection)attachments)) {
            return new BankAttachmentResponse(attachments);
        }
        super.prepareAttachment(attachments);
        String requestUrl = RequestContextUtils.getBankParameterValue((String)"attachment_upload_url");
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
        PaymentInfo paymentInfo = paymentInfoRepository.findByBankDetailSeqID(((PayAttachment)attachments.get(0)).getBankDetailSeqID());
        String implClassName = paymentInfo.getImplClassName();
        HashMap<String, String> runningParams = EBContext.getContext().getRunningParams();
        if (runningParams == null) {
            runningParams = new HashMap<String, String>(1);
        }
        runningParams.put("payImplClassName", implClassName);
        EBContext.getContext().setRunningParams(runningParams);
        String obssid = paymentInfo.getBankRefID();
        AtomicBoolean uploadComplete = new AtomicBoolean(true);
        attachments.forEach(payAttachment -> {
            try {
                payAttachment.setBankRefID(obssid);
                String sequence = Sequence.gen18Sequence();
                this.getTicketAndUpload(requestUrl, obssid, sequence, (PayAttachment)payAttachment);
            }
            catch (Throwable e) {
                String message = e.getMessage();
                if (StringUtils.isNotEmpty((String)message) && message.length() > 255) {
                    message = message.substring(0, 255);
                }
                if (e instanceof EBPayUnknownException) {
                    this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.UNKNOWN, "", message);
                }
                uploadComplete.set(false);
                this.setUploadStatus((PayAttachment)payAttachment, AttachmentState.FAIL, "", message);
            }
        });
        if (uploadComplete.get()) {
            String rqstStr = this.pack((PayAttachment)attachments.get(0));
            String rspStr = super.sendAndRecvMsg(rqstStr);
            this.parseb2e0706(attachments, rspStr);
        }
        return new BankAttachmentResponse(attachments);
    }

    private void parseb2e0706(List<PayAttachment> attachments, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0706-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildText("rspmsg");
        if ("B001".equalsIgnoreCase(rspcod)) {
            Element rs = trn.getChild("b2e0706-rs");
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                this.setUploadStatus(attachments, AttachmentState.SUCCESS, another_rspcod, another_rspmsg);
            } else {
                this.setUploadStatus(attachments, AttachmentState.UNKNOWN, another_rspmsg, another_rspmsg);
            }
        } else {
            this.setUploadStatus(attachments, AttachmentState.UNKNOWN, rspcod, rspmsg);
        }
    }

    private void getTicketAndUpload(String requestUrl, String obssid, String uploadUUID, PayAttachment payAttachment) {
        b2e0705Impl b2e0705 = new b2e0705Impl();
        String overseaAttachmentPath = super.getOverseaAttachmentPath(payAttachment.getBankVersionID());
        String fileName = payAttachment.getFileName();
        long totalLength = FileUtils.getFile((String[])new String[]{overseaAttachmentPath + File.separator + fileName}).length();
        if (totalLength > this.maxFileSize) {
            ArrayList<byte[]> fileByteList = new ArrayList<byte[]>(10);
            try (FileInputStream fis = new FileInputStream(overseaAttachmentPath + File.separator + fileName);){
                int bytesRead;
                byte[] buffer = new byte[0xA00000];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    byte[] b1 = new byte[bytesRead];
                    System.arraycopy(buffer, 0, b1, 0, bytesRead);
                    fileByteList.add(b1);
                }
                for (int i = 0; i < fileByteList.size(); ++i) {
                    byte[] bytes = (byte[])fileByteList.get(i);
                    long offset = this.maxFileSize * (long)i;
                    String b2e0705Response = b2e0705.sendAndRecvMsg(obssid);
                    Map<String, String> parseb2e0705 = this.parseb2e0705(b2e0705Response);
                    Map<String, String> formBody = this.buildFormBody(uploadUUID, offset, totalLength, fileName, parseb2e0705);
                    String responseStr = super.uploadToBankByHttps(requestUrl, bytes, payAttachment.getFileName(), "uploadFile", formBody);
                    boolean uploadSuccess = this.parseUpload(responseStr);
                    if (uploadSuccess) continue;
                    super.uploadToBankByHttps(requestUrl, bytes, payAttachment.getFileName(), "uploadFile", formBody);
                }
            }
            catch (IOException e) {
                this.logger.error("\u6587\u4ef6\u5206\u5305\u5f02\u5e38", (Throwable)e);
            }
        } else {
            String b2e0705Response = b2e0705.sendAndRecvMsg(obssid);
            Map<String, String> parseb2e0705 = this.parseb2e0705(b2e0705Response);
            Map<String, String> formBody = this.buildFormBody(uploadUUID, 0L, totalLength, fileName, parseb2e0705);
            String responseStr = super.uploadToBankByHttps(requestUrl, super.getOverseaAttachmentPath(payAttachment.getBankVersionID()), payAttachment.getFileName(), "uploadFile", formBody);
            boolean uploadSuccess = this.parseUpload(responseStr);
            if (!uploadSuccess) {
                super.uploadToBankByHttps(requestUrl, super.getOverseaAttachmentPath(payAttachment.getBankVersionID()), payAttachment.getFileName(), "uploadFile", formBody);
            }
        }
    }

    private Map<String, String> buildFormBody(String uploadUUID, long fileOffset, long totalLength, String fileName, Map<String, String> parseb2e0705) {
        HashMap<String, String> formBody = new HashMap<String, String>(20);
        formBody.put("uuid", uploadUUID);
        formBody.put("totalLength", String.valueOf(totalLength));
        formBody.put("fileOffset", String.valueOf(fileOffset));
        formBody.put("imageFormat", fileName.substring(fileName.lastIndexOf(".") + 1));
        formBody.put("imgLibId", "5G01");
        formBody.put("bizId", parseb2e0705.get("bizId"));
        formBody.put("pkuuId", parseb2e0705.get("pkuuId"));
        formBody.put("typeId", "5007");
        formBody.put("fileName", fileName);
        formBody.put("resourceUri", parseb2e0705.get("resourceUri"));
        formBody.put("clientId", "B2EP");
        formBody.put("ticketId", parseb2e0705.get("ticket"));
        formBody.put("channelType", "0");
        return formBody;
    }

    private boolean parseUpload(String responseStr) {
        JSONObject jsonObject = JSON.parseObject((String)responseStr);
        JSONObject result = jsonObject.getJSONObject("result");
        String code = result.getString("message.code");
        if ("success".equalsIgnoreCase(code)) {
            this.logger.info("\u9644\u4ef6\u4e0a\u4f20\u6210\u529fimgId:{}", (Object)result.getString("imgId"));
            return true;
        }
        return false;
    }

    private Map<String, String> parseb2e0705(String b2e0705Response) {
        Element rs;
        Element another_status;
        String another_rspcod;
        HashMap<String, String> map = new HashMap<String, String>(20);
        Element root = JDomUtils.string2Root((String)b2e0705Response, (String)RequestContextUtils.getCharset());
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0705-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        if ("B001".equalsIgnoreCase(rspcod) && "B001".equalsIgnoreCase(another_rspcod = (another_status = (rs = trn.getChild("b2e0705-rs")).getChild("status")).getChildTextTrim("rspcod"))) {
            String[] split;
            String ticket = JDomUtils.getChildText((Element)rs, (String)"ticket");
            map.put("ticket", ticket);
            String resourceUri = JDomUtils.getChildText((Element)rs, (String)"resourceUri");
            map.put("resourceUri", resourceUri);
            resourceUri = resourceUri.replaceAll("amp;", "");
            String param = resourceUri.substring(resourceUri.indexOf("?") + 1);
            for (String s : split = param.split("&")) {
                if (!s.contains("=")) continue;
                String[] s1 = s.split("=");
                map.put(s1[0], s1[1]);
            }
            this.logger.info("\u4eceb2e0705\u53d6\u7968\u63a5\u53e3\u83b7\u53d6\u5230\u7ed3\u679c:{}", map);
        }
        return map;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

