/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.adbc.dc.services.Packer;
import kd.ebg.aqap.banks.adbc.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public boolean isSupportPage(BankBalanceRequest request) {
        return true;
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        LocalDate searchDate = bankBalanceRequest.getStartDate();
        String body = this.createBody(bankBalanceRequest.getAcnt().getAccNo(), searchDate);
        String bodyLen = Packer.getLength(body);
        String header = Packer.createHeadMessage("eb.qry.039.1", bodyLen, null);
        return header + body;
    }

    private String createBody(String accountNo, LocalDate date) {
        String encoding = RequestContextUtils.getCharset();
        StringBuilder sbBody = new StringBuilder();
        sbBody.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\"?>\r\n");
        sbBody.append("<Document xmlns=\"").append("eb.qry.039.1").append("\">\r\n");
        sbBody.append("<InqAccount>");
        sbBody.append("<Account>").append(accountNo).append("</Account>");
        sbBody.append("<Date>").append(LocalDateUtil.formatDate((LocalDate)date, (String)"yyyy-MM-dd")).append("</Date>");
        sbBody.append("</InqAccount>");
        sbBody.append("</Document>");
        return sbBody.toString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BankAcnt bankAcnt = rqst.getAcnt();
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, bankAcnt);
        ArrayList<BalanceInfo> lists = new ArrayList<BalanceInfo>(1);
        lists.add(balanceInfo);
        bankBalanceResponse.setBalances(lists);
        if (StringUtils.isEmpty((String)rspStr)) {
            this.logger.info("\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            balanceInfo.setError(ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a", (String)"TodayBalanceParser_0", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]));
            return bankBalanceResponse;
        }
        BankResponse bankResponse = Parser.parseResponse(rspStr);
        if (!"S0000".equals(bankResponse.getResponseCode())) {
            this.logger.info("\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a{}; \u8fd4\u56de\u7801\u63cf\u8ff0\uff1a{}", new Object[]{bankResponse.getResponseCode(), bankResponse.getResponseMessage()});
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        this.getBalance(rspStr, balanceInfo, rqst);
        this.setBankCurrency(balanceInfo, rqst.getBankCurrency());
        return bankBalanceResponse;
    }

    public void getBalance(String rspStr, BalanceInfo balanceInfo, BankBalanceRequest rqst) {
        int index = rspStr.indexOf("}\r\n");
        String body = rspStr.substring(index + 1);
        String a = body.substring(body.indexOf(" xmlns="), body.indexOf("\">") + 1);
        String context = body.replace(a, "");
        Element bankDate = JDomUtils.string2Root((String)context, (String)RequestContextUtils.getCharset());
        Element accountBalance = bankDate.getChild("AccountBalance");
        String hisBalance = accountBalance.getChildTextTrim("Hisbalance");
        String hisDate = accountBalance.getChildTextTrim("Hisdate");
        String account = accountBalance.getChildTextTrim("Account");
        this.setBankAcnt(balanceInfo, Lists.newArrayList((Object[])new BankAcnt[]{balanceInfo.getBankAcnt()}), account);
        this.setCurrentBalance(balanceInfo, hisBalance);
        this.setAvailableBalance(balanceInfo, hisBalance);
        if (StringUtils.isNotEmpty((String)hisDate)) {
            hisDate = hisDate.replaceAll("[^0-9]", "");
            this.setBalanceDateTime(balanceInfo, hisDate + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        } else {
            this.setBalanceDateTime(balanceInfo, rqst.getStartDate().atTime(23, 59, 59));
        }
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "eb.qry.039.1";
    }

    public String getBizDesc() {
        return "";
    }

    public int queryDays() {
        return 1;
    }
}

