/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.adbc.dc.services.Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailParser {
    private static final Logger logger = LoggerFactory.getLogger(DetailParser.class);
    private static int pageSize = 50;

    public List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr, String pageNum) {
        List<DetailInfo> detailInfoList = new ArrayList<DetailInfo>();
        BankResponse rsp = Parser.parseResponse(rspStr);
        if ("S0000".equals(rsp.getResponseCode())) {
            detailInfoList = this.getDetail(rspStr, rqst.getAcnt(), rqst);
            logger.info("\u67e5\u8be2\u5386\u53f2\u8d26\u6237\u6c47\u5212\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801S0000, \u67e5\u8be2\u6210\u529f\u3002");
        } else {
            RequestContextUtils.setRunningParam((String)"lastPageKey", (String)"true");
        }
        return detailInfoList;
    }

    public List<DetailInfo> getDetail(String rspStr, BankAcnt reqAcnt, BankDetailRequest rqst) {
        String context = Parser.getRespContext(rspStr);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            Element bankDate = JDomUtils.string2Root((String)context, (String)"UTF-8");
            Element accounts = bankDate.getChild("GiroInfo");
            String account = accounts.getChildTextTrim("Account");
            String date = accounts.getChildTextTrim("Date");
            if (!reqAcnt.getAccNo().equals(account)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u53f7\u4e0e\u8bf7\u6c42\u8d26\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6c42\u8d26\u53f7\u4e3a\uff1a%1$s\u3002", (String)"DetailParser_4", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), reqAcnt.getAccNo()));
            }
            List accountDetailsList = accounts.getChildren("GiroDetails");
            logger.info("accountDetailsList-----{}", (Object)accountDetailsList.size());
            DetailInfo detailInfo = null;
            for (Element accountDetails : accountDetailsList) {
                detailInfo = new DetailInfo();
                String transferSum = accountDetails.getChildText("Amount");
                String flag = accountDetails.getChildText("Flag");
                String offerSetAccount = accountDetails.getChildText("OfferSetAccount");
                String offerSetName = accountDetails.getChildText("OfferSetName");
                String offerSetBankName = accountDetails.getChildText("OfferSetBankName");
                String transferFlowNo = accountDetails.getChildText("BankSerial");
                logger.info("\u94f6\u884c\u6d41\u6c34\u53f7-----{}", (Object)transferFlowNo);
                String transferDate = accountDetails.getChildText("TransDate");
                String transferTime = accountDetails.getChildText("TransTime");
                String usage = accountDetails.getChildText("Usage");
                String extContent = accountDetails.getChildText("ExtContent");
                String remark = accountDetails.getChildText("Remark");
                String balance = accountDetails.getChildText("Balance");
                if ("0".equals(flag)) {
                    detailInfo.setDebitAmount(new BigDecimal(transferSum));
                    detailInfo.setCreditAmount(BigDecimal.valueOf(0.0));
                } else {
                    detailInfo.setDebitAmount(BigDecimal.valueOf(0.0));
                    detailInfo.setCreditAmount(new BigDecimal(transferSum));
                }
                detailInfo.setAccNo(reqAcnt.getAccNo());
                detailInfo.setAccName(reqAcnt.getAccName());
                detailInfo.setBankName(reqAcnt.getBankName());
                detailInfo.setBankVersionID(reqAcnt.getBankVersionId());
                detailInfo.setBankLoginID(reqAcnt.getBankLoginId());
                detailInfo.setCurrency(rqst.getBankCurrency());
                detailInfo.setOppAccNo(offerSetAccount);
                detailInfo.setOppAccName(offerSetName);
                detailInfo.setOppBankName(offerSetBankName);
                detailInfo.setBankDetailNo(transferFlowNo);
                if (!StringUtils.isEmpty((String)transferDate)) {
                    try {
                        if (!StringUtils.isEmpty((String)transferTime)) {
                            detailInfo.setTransTime(LocalDateTime.parse(transferDate.replaceAll("-", "") + transferTime.replaceAll(":", ""), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                        }
                        detailInfo.setTransTime(LocalDateTime.parse(transferDate.replaceAll("-", "") + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1a%1$s\u3002", (String)"DetailParser_5", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
                    }
                } else {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailParser_2", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]));
                }
                String exp = extContent + " " + remark;
                detailInfo.setExplanation(exp.trim());
                detailInfo.setTransDate(LocalDateUtil.date2LocalDate((Date)DateUtil.string2Date((String)transferDate, (String)"yyyy-MM-dd")));
                detailInfo.setBalance(StringUtils.isEmpty((String)balance) ? null : new BigDecimal(balance));
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(accountDetails);
                detailInfo.setJsonMap(jsonStr);
                String accNo = reqAcnt.getAccNo();
                String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate(), (String)"yyyyMMdd");
                String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detailInfo.setReceiptNo(receiptNo);
                detailInfos.add(detailInfo);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8d26\u6237\u6c47\u5212\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u5931\u8d25--%1$s\u3002", (String)"DetailParser_6", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), rspStr), (Throwable)e);
        }
        return detailInfos;
    }
}

