/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.payment.batchPay;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.adbc.dc.services.Packer;
import kd.ebg.aqap.banks.adbc.dc.services.payment.PretreatmentImpl;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;

final class PayPacker {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PretreatmentImpl.class);

    PayPacker() {
    }

    public String packPay(PaymentInfo[] paymentInfos) {
        this.logger.info("\u6279\u91cf\u652f\u4ed8\u4ea4\u6613\u5f00\u59cb----paymentInfos.length===" + paymentInfos.length);
        String body = this.createBody(paymentInfos);
        String bodyLen = Packer.getLength(body);
        String header = Packer.createHeadMessage("eb.biz.003.1", bodyLen, paymentInfos);
        String reqMsg = header + body;
        return reqMsg;
    }

    private String createBody(PaymentInfo[] paymentInfos) {
        this.logger.info("\u5c01\u88c5\u6279\u91cf\u4ea4\u6613\u62a5\u6587\u5f00\u59cb------");
        StringBuilder sbBody = new StringBuilder();
        StringBuilder sbBody1 = new StringBuilder();
        try {
            BigDecimal amount = new BigDecimal("0.00");
            sbBody1.append("</Sum>");
            sbBody1.append("</TotalRecord>");
            for (int i = 0; i < paymentInfos.length; ++i) {
                String listCode = String.format("%03d", i + 1);
                sbBody1.append("<BchPayDetails>");
                sbBody1.append("<ListCode>").append(listCode).append("</ListCode>");
                sbBody1.append("<PayerAccount>").append(paymentInfos[i].getAccNo()).append("</PayerAccount>");
                sbBody1.append("<PayerName>").append(paymentInfos[i].getAccName()).append("</PayerName>");
                sbBody1.append("<PayeeAccount>").append(paymentInfos[i].getIncomeAccNo()).append("</PayeeAccount>");
                sbBody1.append("<PayeeName>").append(paymentInfos[i].getIncomeAccName()).append("</PayeeName>");
                sbBody1.append("<PayeeOpenBankCode>").append(paymentInfos[i].getIncomeCnaps() != null ? paymentInfos[i].getIncomeCnaps() : "").append("</PayeeOpenBankCode>");
                sbBody1.append("<Amount>").append(paymentInfos[i].getAmount().toPlainString()).append("</Amount>");
                sbBody1.append("<Usage>").append(paymentInfos[i].getUseCn()).append("</Usage>");
                sbBody1.append("<InstancyStatus>0</InstancyStatus>");
                sbBody1.append("<ExtContent>").append(paymentInfos[i].getExplanation()).append("</ExtContent>");
                sbBody1.append("</BchPayDetails>");
                amount = amount.add(paymentInfos[i].getAmount());
                PaymentInfoSysFiled.set((PaymentInfo)paymentInfos[i], (String)"ListCode", (String)listCode);
            }
            sbBody1.append("</BchPayInfo>");
            sbBody1.append("</Document>");
            sbBody.append("<?xml version=\"1.0\" encoding=\"").append(RequestContextUtils.getCharset()).append("\"?>\r\n");
            sbBody.append("<Document xmlns=\"").append("eb.biz.003.1").append("\">\r\n");
            sbBody.append("<BchPayInfo>");
            sbBody.append("<TotalRecord>");
            sbBody.append("<TotalNumber>").append(paymentInfos.length).append("</TotalNumber>");
            sbBody.append("<Sum>").append(amount.toPlainString());
        }
        catch (Exception e) {
            this.logger.info("\u5c01\u88c5\u6279\u91cf\u4ea4\u6613\u62a5\u6587\u51fa\u9519", (Object)e);
        }
        this.logger.info("\u5c01\u88c5\u6279\u91cf\u4ea4\u6613\u62a5\u6587\u7ed3\u675f------");
        return sbBody.append((CharSequence)sbBody1).toString();
    }
}

