/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.payment.singlePay;

import java.math.BigDecimal;
import java.time.LocalDate;
import kd.ebg.aqap.banks.adbc.dc.services.Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class QueryPayPacker {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayPacker.class);

    public String packQueryPay(PaymentInfo[] paymentInfos) {
        this.logger.info("\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u62a5\u6587\u5c01\u88c5-----\u5f00\u59cb---");
        String body = this.createBody(paymentInfos);
        String bodyLen = Packer.getLength(body);
        String header = Packer.createHeadMessage("eb.biz.005.1", bodyLen, paymentInfos);
        String reqMsg = header + body;
        this.logger.info("\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u62a5\u6587\u5c01\u88c5-----\u7ed3\u675f---");
        return reqMsg;
    }

    private String createBody(PaymentInfo[] paymentInfos) {
        StringBuilder sbBody = new StringBuilder();
        String encoding = "UTF-8";
        try {
            String messageCode = "";
            if (paymentInfos != null) {
                String id = paymentInfos[0].getBankBatchSeqId();
                if (id.length() <= 16) {
                    messageCode = String.format("%-16s", id);
                } else if (id.length() > 16) {
                    messageCode = id.substring(id.length() - 16);
                }
                this.logger.info("queryPay id.length()-----" + messageCode);
                this.logger.info("paymentInfos.length-----" + paymentInfos.length);
                String requestTime = LocalDateUtil.formatDate((LocalDate)paymentInfos[0].getRequestTime().toLocalDate(), (String)"yyyy-MM-dd");
                String sendCode = RequestContextUtils.getParameter().getBankParameter("user_id");
                BigDecimal amount = paymentInfos[0].getAmount().setScale(2, 4);
                this.logger.info("\u652f\u4ed8\u4ea4\u6613\u8bf7\u6c42\u65f6\u95f4-----\u5f00\u59cb---" + requestTime);
                sbBody.append("<?xml version=\"1.0\" encoding=\"").append(RequestContextUtils.getCharset()).append("\"?>\r\n");
                sbBody.append("<Document xmlns=\"").append("eb.biz.005.1").append("\">\r\n");
                sbBody.append("<OriginalInfo>");
                sbBody.append("<OSendCode>").append(sendCode).append("</OSendCode>");
                sbBody.append("<OMessageCode>").append(paymentInfos[0].getBankBatchSeqId()).append("</OMessageCode>");
                sbBody.append("<OMesgCode>").append("eb.biz.001.1").append("</OMesgCode>");
                sbBody.append("<OTransDate>").append(requestTime).append("</OTransDate>");
                sbBody.append("</OriginalInfo>");
                sbBody.append("<InqPay>");
                sbBody.append("<TotalRecord>");
                sbBody.append("<TotalNumber>1</TotalNumber><Sum>").append(amount).append("</Sum>");
                sbBody.append("</TotalRecord>");
                sbBody.append("<QueryPayDetails><OriginalListCode>001</OriginalListCode></QueryPayDetails>");
                sbBody.append("</InqPay>");
                sbBody.append("</Document>");
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        return sbBody.toString();
    }
}

