/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccbasia.ccip.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CCBASIABankResponse;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccbasia.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccbasia.ccip.services.LoginUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.frame.Sequence;
import org.jdom2.Content;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        LoginUtils.toLogin();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSERH4", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        JDomExtUtils.addChildCDData((Element)request, (String)"Inst_SvrlLgPsn_ID", (String)RequestContextUtils.getBankParameterValue((String)"inst_svrllgpsn_id"));
        JDomExtUtils.addChildCDData((Element)request, (String)"Rvl_Rcrd_Num", (String)"1");
        JDomExtUtils.addChildCDData((Element)request, (String)"CcyCd", (String)bankBalanceRequest.getHeader().getBankCurrency());
        JDomExtUtils.addChildCDData((Element)request, (String)"CshEx_Cd", (String)"1");
        JDomExtUtils.addChildCDData((Element)request, (String)"StDt", (String)bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData((Element)request, (String)"EdDt", (String)bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData((Element)list1, (String)"AccNo", (String)bankBalanceRequest.getHeader().getAcnt().getAccNo());
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        CCBASIABankResponse rsp = CommonParser.getFrontResponse(rspStr);
        if (!rsp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-ccbasia-ccip", (Object[])new Object[0]), rsp.getResponseCode() + rsp.getResponseMessage()));
        }
        rspStr = rsp.getBankMsg();
        CCBASIABankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List list1 = response.getChildren("LIST1");
        ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(10);
        for (Element list : list1) {
            BalanceInfo info = new BalanceInfo();
            String accNo = JDomExtUtils.getChildText((Element)list, (String)"AccNo");
            String currency = JDomExtUtils.getChildText((Element)list, (String)"CcyCd");
            String acBa = JDomExtUtils.getChildText((Element)list, (String)"AcBa");
            String accAvlBal = JDomExtUtils.getChildText((Element)list, (String)"Acc_Avl_Bal");
            String txnDt = JDomExtUtils.getChildText((Element)list, (String)"Txn_Dt");
            this.setBankAcnt(info, bankBalanceRequest.getBankAcntList(), accNo);
            this.setBankCurrency(info, bankBalanceRequest.getBankCurrency(), currency);
            this.setCurrentBalance(info, acBa);
            this.setAvailableBalance(info, accAvlBal);
            this.setBalanceDateTime(info, txnDt + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            result.add(info);
        }
        return new EBBankBalanceResponse(result);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "P1CMSERH4";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u5883\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-ccbasia-ccip", (Object[])new Object[0]);
    }
}

