/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Header4Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.OPCB000063_Receive;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.helper.Packer;
import kd.ebg.aqap.banks.bsz.dc.helper.Parser;
import kd.ebg.aqap.banks.bsz.dc.utils.ApiUtils;
import kd.ebg.aqap.banks.bsz.dc.utils.Utils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(HisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        return null;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        ArrayList balanceInfoList = new ArrayList(8);
        try {
            LocalDate startDate = request.getStartDate();
            LocalDate endDate = request.getEndDate();
            while (!startDate.isAfter(endDate)) {
                Map bodyMap = Packer.getSendObject(request, this.getBizCode());
                logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)bodyMap.toString());
                String responseStr = ApiUtils.doPostRequest(bodyMap);
                logger.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseStr);
                startDate = startDate.plusDays(1L);
                balanceInfoList.addAll(this.parse(request, responseStr).getBalances());
            }
            return new EBBankBalanceResponse(balanceInfoList);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage());
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        try {
            Root root = Parser.getRecvObject(responseStr, this.getBizCode());
            return this.recvStrategy(root, request);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage());
        }
    }

    public EBBankBalanceResponse recvStrategy(Root<Header4Receive, OPCB000063_Receive> root, BankBalanceRequest bankBalanceRequest) throws Exception {
        Header4Receive header = root.getHeader();
        OPCB000063_Receive body = root.getBody();
        String headStatusCode = Utils.nullAsBlank(header.getRET_CODE());
        String headStatusMsg = Utils.nullAsBlank(header.getRET_MSG());
        Utils.checkRspCode(headStatusCode, headStatusMsg, "000000");
        if (Utils.allfieldIsNUll(body)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u62a5\u6587header\u72b6\u6001\u4e3a000000\uff0c\u4f46body\u4e3a\u7a7a\uff0c\u9700\u8be6\u8be2\u94f6\u884c\uff01", (String)"OPCB000003_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]));
        }
        List<OPCB000063_Receive.Bill> billList = body.getBillList();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        for (OPCB000063_Receive.Bill bill : billList) {
            BalanceInfo balance = new BalanceInfo();
            balance.setBankAcnt(bankBalanceRequest.getAcnt());
            balance.setBankCurrency(bankBalanceRequest.getCurrency());
            balance.setBalanceDateTime(bankBalanceRequest.getStartDate().atTime(0, 0));
            try {
                String ye = bill.getBalance();
                String kyye = bill.getActualBal();
                this.setAvailableBalance(balance, kyye);
                this.setCurrentBalance(balance, ye);
                String dataDate = bill.getDataDate();
                LocalDate localDate = LocalDateUtil.parserDate((String)dataDate);
                if (localDate.isBefore(bankBalanceRequest.getEndDate()) || localDate.isAfter(bankBalanceRequest.getEndDate())) continue;
                balance.setBalanceDateTime(bankBalanceRequest.getStartDate().atTime(0, 0));
            }
            catch (Exception e) {
                balance.setError(e.getMessage());
            }
            balanceInfos.add(balance);
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList(balanceInfos));
    }

    public String getDeveloper() {
        return "cw";
    }

    public String getBizCode() {
        return "OPCB000063";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 1;
    }

    public LocalDate limitDate() {
        return null;
    }
}

