/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bsz.dc.services.payment.individual.batch;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bsz.dc.bean.Root;
import kd.ebg.aqap.banks.bsz.dc.helper.Packer;
import kd.ebg.aqap.banks.bsz.dc.helper.Parser;
import kd.ebg.aqap.banks.bsz.dc.utils.ApiUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BatchIndividualQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BatchIndividualQueryPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        try {
            Root root = Parser.getRecvObject(responseStr, this.getBizCode());
            List paymentInfos = (List)Parser.analyse(this.getBizCode(), bankPayRequest.getPaymentInfos(), root);
            return new EBBankPayResponse(paymentInfos);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u4ed8\u6b3e\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4ed8\u6b3e\u67e5\u8be2\u5f02\u5e38\uff1a%s", (String)"BatchIndividualQueryPayImpl_0", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        try {
            Map bodyMap = Packer.getSendObject(bankPayRequest.getPaymentInfos(), this.getBizCode());
            logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)bodyMap.toString());
            String responseStr = ApiUtils.doPostRequest(bodyMap);
            logger.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseStr);
            return this.parse(bankPayRequest, responseStr);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            logger.error("\u6279\u91cf\u5bf9\u79c1\u4ed8\u6b3e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u79c1\u4ed8\u6b3e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (String)"BatchIndividualQueryPayImpl_1", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u79c1\u4ed8\u6b3e\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s", (String)"BatchIndividualQueryPayImpl_2", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public String getDeveloper() {
        return "lw";
    }

    public String getBizCode() {
        return "OPCB000019";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u79c1\u652f\u4ed8\u67e5\u8be2", (String)"BatchIndividualQueryPayImpl_3", (String)"ebg-aqap-banks-bsz-dc", (Object[])new Object[0]);
    }
}

