/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citi.dc;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem CITI_DC_BICCODE = PropertyConfigItem.builder().key("CITI_DC_BICCODE").mlName(new MultiLangEnumBridge("SWIFT CODE", "BankBusinessConfig_0", "ebg-aqap-banks-citi-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("SWIFT Code\uff08\u94f6\u884c\u56fd\u9645\u4ee3\u7801\uff09\uff1a\u8de8\u5883\u652f\u4ed8/\u5883\u5185\u5916\u5e01\u4e1a\u52a1\u4f7f\u7528\uff0c\u901a\u5e38\u75318\u621611\u4f4d\u6570\u5b57\u548c\u5b57\u6bcd\u7ec4\u6210\u3002", "BankBusinessConfig_9", "ebg-aqap-banks-citi-dc"), new MultiLangEnumBridge("\u6b64\u914d\u7f6e\u4f7f\u7528\u63a5\u53e3\u6709\uff1aACH\u3001CBFT\u3001DFT\u63a5\u53e3\u3002", "BankBusinessConfig_10", "ebg-aqap-banks-citi-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem CITI_DC_BANKCITY = PropertyConfigItem.builder().key("CITI_DC_BANKCITY").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u57ce\u5e02\uff08\u82f1\u6587\uff09", "BankBusinessConfig_1", "ebg-aqap-banks-citi-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u94f6\u884c\u57ce\u5e02\uff08\u82f1\u6587\uff09", "BankBusinessConfig_1", "ebg-aqap-banks-citi-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem CITI_DC_PAY_COMPANY_ACNT = PropertyConfigItem.builder().key("CITI_DC_PAY_COMPANY_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-citi-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_2", "ebg-aqap-banks-citi-dc")})).isAccNo(true).build();
    public static final PropertyConfigItem CITI_DC_PAY_COMPANY_STREET_ACNT = PropertyConfigItem.builder().key("CITI_DC_PAY_COMPANY_STREET_ACNT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-citi-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u516c\u53f8\u8857\u9053\u540d\u79f0\uff08\u82f1\u6587\uff09", "BankBusinessConfig_3", "ebg-aqap-banks-citi-dc")})).isAccNo(true).build();
    private static final PropertyConfigItem CITI_DC_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("CITI_DC_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_7", "ebg-aqap-banks-citi-dc")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_8", "ebg-aqap-banks-citi-dc")})).set2Integer().build();

    public boolean isForeignBank() {
        return true;
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List lists = this.getBankAddtionalPropertyConfigItems(false, false, false);
        ArrayList propertyConfigItems = Lists.newArrayList((Object[])new PropertyConfigItem[]{CITI_DC_BICCODE, CITI_DC_BANKCITY, CITI_DC_PAY_COMPANY_ACNT, CITI_DC_PAY_COMPANY_STREET_ACNT, CITI_DC_PAY_STATE_TIMEOUT});
        lists.addAll(propertyConfigItems);
        return lists;
    }

    public static String getBicCode(String accNo) {
        return CITI_DC_BICCODE.getCurrentValueWithObjectID(accNo);
    }

    public static String getBankCity(String accNo) {
        return CITI_DC_BANKCITY.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCompany(String accNo) {
        return CITI_DC_PAY_COMPANY_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static String getPayCompanyStreet(String accNo) {
        return CITI_DC_PAY_COMPANY_STREET_ACNT.getCurrentValueWithObjectID(accNo);
    }

    public static int getPayStateTimeout() {
        String timeOut = CITI_DC_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != timeOut && timeOut.length() > 0) {
            try {
                if (Integer.parseInt(timeOut) > 0) {
                    timeout = Integer.parseInt(timeOut);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime deadlineTime = submitSuccessTime.plus(payStateTimeout, ChronoUnit.HOURS);
        return deadlineTime.isBefore(LocalDateTime.now());
    }
}

