/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bjb.opa.service.payment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bjb.opa.service.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonPacker;
import kd.ebg.aqap.banks.bjb.opa.service.utils.CommonParser;
import kd.ebg.aqap.banks.bjb.opa.service.utils.ResBean;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        JSONObject requestJson = CommonPacker.createData(paymentInfo.getBatchSeqID(), this.getBizCode());
        JSONObject opReqSet = new JSONObject();
        opReqSet.put("payEnpName", (Object)paymentInfo.getAccName());
        opReqSet.put("payAcct", (Object)paymentInfo.getAccNo());
        opReqSet.put("recAcct", (Object)paymentInfo.getIncomeAccNo());
        opReqSet.put("recAcctName", (Object)paymentInfo.getIncomeAccName());
        opReqSet.put("recBankName", (Object)paymentInfo.getIncomeBankName());
        BigDecimal amount = paymentInfo.getAmount();
        opReqSet.put("amount", (Object)amount.multiply(new BigDecimal(100)).setScale(0).toPlainString());
        opReqSet.put("payUse", (Object)paymentInfo.getExplanation());
        opReqSet.put("remark", (Object)paymentInfo.getExplanation());
        if (paymentInfo.is2SameBank()) {
            opReqSet.put("transFlag", (Object)"0");
            opReqSet.put("transmitType", (Object)"0");
        } else if (paymentInfo.is2SameCity()) {
            opReqSet.put("transFlag", (Object)"1");
            opReqSet.put("transmitType", (Object)"1");
        } else {
            opReqSet.put("transFlag", (Object)"2");
            opReqSet.put("transmitType", (Object)"2");
        }
        if (paymentInfo.is2Individual()) {
            opReqSet.put("recDepType", (Object)"1");
        } else {
            opReqSet.put("recDepType", (Object)"0");
        }
        opReqSet.put("isAgreeFlag", (Object)"1");
        JSONArray array = new JSONArray();
        array.add((Object)opReqSet);
        requestJson.put("opReqSet", (Object)array);
        String xmlRequest = CommonPacker.createRequest("pay", requestJson.toJSONString());
        return xmlRequest;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        ResBean resBean = CommonParser.parseCommonResponse(res);
        if ("BEFORE_SUBMIT_FAIL".equals(resBean.getRetCode())) {
            this.logger.error("\u4ee3\u7406\u7a0b\u5e8f\u63d0\u4ea4\u94f6\u884c\u5931\u8d25");
            EBGBusinessUtils.setPaymentState((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)resBean.getRetCode(), (String)resBean.getRetMes());
            ((PaymentInfo)paymentInfos.get(0)).setBackErrorMsg(resBean.getRetMes());
            ((PaymentInfo)paymentInfos.get(0)).setUpdateOperation(UpdateOpState.PAY_FAIL.getId());
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"SUBMIT_SUCCESS".equals(resBean.getRetCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)resBean.getRetCode(), (String)resBean.getRetMes());
            return new EBBankPayResponse(paymentInfos);
        }
        res = resBean.getData();
        JSONObject response = JSONObject.parseObject((String)res);
        String retCode = response.getString("resultCode");
        String errMsg = response.getString("errMsg");
        String orderSerialNo = response.getString("orderSerialNo");
        if ("000000".equals(retCode)) {
            ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).setBankRefID(orderSerialNo);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)retCode, (String)errMsg);
        } else {
            ((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).setBankRefID(orderSerialNo);
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)retCode, (String)errMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "CebankPayWithNewPrecontractOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-bjb-opa", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

