/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ParserHelper {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParserHelper.class);

    public static void parserRep(String msg, Element opRep) {
        String serialNo = opRep.getChildTextTrim("serialNo");
        String returnCode = opRep.getChildTextTrim("hostReturnCode");
        String errMsg = opRep.getChildTextTrim("hostErrorMessage");
        if (!serialNo.equals(PackerHelper.getThreadSeq())) {
            logger.info("\u8bf7\u6c42\u5e8f\u5217\u53f7\u4e0e\u8fd4\u56de\u62a5\u6587\u5e8f\u5217\u53f7\u4e0d\u7b26" + PackerHelper.getThreadSeq() + ":" + serialNo);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%s\u8bf7\u6c42\u5e8f\u5217\u53f7\u4e0e\u8fd4\u56de\u62a5\u6587\u5e8f\u5217\u53f7\u4e0d\u7b26\u3002", (String)"ParserHelper_7", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), msg));
        }
        if (Pattern.matches("9+", returnCode)) {
            logger.info("\u8bf7\u6c42\u8d85\u65f6" + returnCode);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u6c42\u8d85\u65f6%2$s\u3002", (String)"ParserHelper_8", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), msg, StringUtils.catWithSpace((String[])new String[]{returnCode, errMsg})));
        }
        if (!Pattern.matches("0+", returnCode)) {
            logger.info("\u8bf7\u6c42\u8d85\u65f6" + returnCode);
            throw EBExceiptionUtil.serviceException((String)(msg + StringUtils.catWithSpace((String[])new String[]{returnCode, errMsg})));
        }
    }

    public static void parserPayResult(List<PaymentInfo> paymentInfos, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr.substring(56), (String)EBContext.getContext().getCharsetName());
        Element opRep = root.getChild("opRep");
        String serialNo = opRep.getChildTextTrim("serialNo");
        String returnCode = opRep.getChildTextTrim("hostReturnCode");
        String errMsg = opRep.getChildTextTrim("hostErrorMessage");
        if (Pattern.matches("9+", returnCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"ParserHelper_2", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)returnCode, (String)errMsg);
        } else if (Pattern.matches("0+", returnCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ParserHelper_3", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)returnCode, (String)errMsg);
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"ParserHelper_2", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)returnCode, (String)errMsg);
        }
    }

    public static void parserQueryResult(List<PaymentInfo> paymentInfo, Element opRep) {
        String serialNo = opRep.getChildTextTrim("serialNo");
        String returnCode = opRep.getChildTextTrim("hostReturnCode");
        String errMsg = opRep.getChildTextTrim("hostErrorMessage");
        if (Pattern.matches("9+", returnCode)) {
            EBGBusinessUtils.setPaymentState(paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"ParserHelper_2", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)returnCode, (String)errMsg);
        } else if (Pattern.matches("0+", returnCode)) {
            Element repParam = opRep.getChild("RepParam");
            String state = repParam.getChildTextTrim("state");
            String errorMessage = repParam.getChildTextTrim("errorMessage");
            if ("1".equals(state)) {
                EBGBusinessUtils.setPaymentState(paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ParserHelper_4", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)state, (String)errorMessage);
            } else if ("2".equals(state)) {
                EBGBusinessUtils.setPaymentState(paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ParserHelper_5", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)state, (String)errorMessage);
            } else if ("3".equals(state)) {
                EBGBusinessUtils.setPaymentState(paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"ParserHelper_3", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)returnCode, (String)errMsg);
            }
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"ParserHelper_6", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]), (String)returnCode, (String)errMsg);
        }
    }

    public static Map<String, PaymentInfo> getPaymentInfoMap(List<PaymentInfo> paymentInfos) {
        return paymentInfos.stream().collect(Collectors.toMap(PaymentInfo::getBankDetailSeqId, paymentInfo -> paymentInfo));
    }

    public static PaymentState getState(String state) {
        return "COMPLETE".equals(state) ? PaymentState.SUCCESS : ("FAIL".equals(state) ? PaymentState.FAIL : PaymentState.UNKNOWN);
    }
}

