/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest request) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("accountNo", request.getAcnt().getAccNo());
        map.put("beginDate", PackerHelper.formatDate(request.getStartDate()));
        map.put("endDate", PackerHelper.formatDate(request.getEndDate()));
        return PackerHelper.packXML(map, this.getBizCode());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr.substring(56), (String)EBContext.getContext().getCharsetName());
        Element opRep = root.getChild("opRep");
        int recordNum = -1;
        String record_num = opRep.getChildTextTrim("turnPageTotalNum");
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        if (recordNum < 0) {
            return new EBBankDetailResponse(details);
        }
        Element repBody = opRep.getChild("RepParam");
        Element detail = repBody.getChild("tranDetail");
        List list = detail.getChildren("row");
        for (Element element : list) {
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setCurrency(element.getChildText("currencyType"));
            detailInfo.setExplanation(element.getChildText("rem"));
            String payAmount = element.getChildText("payAmount");
            String recAmount = element.getChildText("recAmount");
            detailInfo.setDebitAmount(new BigDecimal(StringUtils.isEmpty((String)payAmount) ? "0.00" : payAmount));
            detailInfo.setCreditAmount(new BigDecimal(StringUtils.isEmpty((String)recAmount) ? "0.00" : recAmount));
            if (!StringUtils.isEmpty((String)element.getChildText("balance"))) {
                detailInfo.setBalance(new BigDecimal(element.getChildText("balance")));
            }
            detailInfo.setTransDate(PackerHelper.parseDate(element.getChildTextTrim("transferDate")));
            detailInfo.setTransTime(PackerHelper.parseDateTime(element.getChildTextTrim("transferDate") + element.getChildTextTrim("transferTime")));
            detailInfo.setAccName(bankDetailRequest.getAcnt().getAccName());
            detailInfo.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detailInfo.setOppAccName(element.getChildTextTrim("accountName"));
            detailInfo.setOppAccNo(element.getChildTextTrim("account"));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            detailInfo.setJsonMap(jsonStr);
            detailInfo.setBankDetailNo(element.getChildTextTrim("transferFlowNo"));
            String accNo = bankDetailRequest.getHeader().getAcnt().getAccNo();
            String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            details.add(detailInfo);
        }
        return new EBBankDetailResponse(details);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "queryAccHisDetail";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(PackerHelper.addUrl());
    }
}

