/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services.payment.interbank;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.banks.sdcs.dc.services.ParserHelper;
import kd.ebg.aqap.banks.sdcs.dc.services.payment.PaymentQuery;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class InterBankPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return PaymentQuery.class;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "otherAccPay";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u8f6c\u8d26", (String)"InterBankPayImpl_0", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return Objects.equals(paymentInfo.getSubBizType(), "pay") && !paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        String serial = PackerHelper.getSeq();
        PaymentInfo payInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        PaymentInfoSysFiled.set((PaymentInfo)payInfo, (String)"pay_serial", (String)serial);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("payAccount", payInfo.getAccNo());
        map.put("payAccountName", payInfo.getAccName());
        map.put("recAccount", payInfo.getIncomeAccNo());
        map.put("recAccountName", payInfo.getIncomeAccName());
        map.put("recAccountOpenBank", payInfo.getIncomeCnaps());
        map.put("recAccountOpenBankName", payInfo.getIncomeBankName());
        map.put("payAmount", payInfo.getAmount().toString());
        map.put("remRoute", payInfo.getAmount().compareTo(new BigDecimal(50000)) >= 0 ? "5" : "7");
        map.put("currencyType", payInfo.getCurrency());
        map.put("payUse", payInfo.getExplanation());
        map.put("orderFlowNo", serial);
        map.put("trsDateTime", PackerHelper.formatDateTime(LocalDateTime.now()));
        return PackerHelper.packXML(map, this.getBizCode(), serial);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        ParserHelper.parserPayResult(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(PackerHelper.addUrl());
    }
}

