/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.payment.batchpay;

import java.util.List;
import kd.ebg.aqap.banks.arcu.dc.services.payment.batchpay.BtcQryPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.payment.common.CommonParser;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BtcPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 20;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BtcQryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = ARCU_DC_Packer.getCommonHeader("B2EBatchTransfer", paymentInfo.getBankBatchSeqId(), paymentInfo.getRequestTime());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"TotalCount", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"Amount", (String)paymentInfo.getTotalAmount().toString());
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element map = JDomUtils.addChild((Element)list, (String)"Map");
            PaymentInfo p = (PaymentInfo)paymentInfos.get(i);
            if (p.is2SameBank()) {
                JDomUtils.addChild((Element)map, (String)"SysFlag", (String)"0");
                JDomUtils.addChild((Element)map, (String)"Priority");
                JDomUtils.addChild((Element)map, (String)"UnionDeptId");
                JDomUtils.addChild((Element)map, (String)"PayeeBankName", (String)p.getBankName());
            } else {
                JDomUtils.addChild((Element)map, (String)"SysFlag", (String)"1");
                JDomUtils.addChild((Element)map, (String)"Priority", (String)(p.is2Urgent() ? "1" : "0"));
                JDomUtils.addChild((Element)map, (String)"UnionDeptId", (String)p.getIncomeCnaps());
                JDomUtils.addChild((Element)map, (String)"PayeeBankName", (String)p.getIncomeBankName());
            }
            JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)p.getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)p.getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"Amount", (String)p.getAmount().toString());
            JDomUtils.addChild((Element)map, (String)"Remark", (String)p.getExplanation());
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        CommonParser.parserCommonInfo(paymentInfos, s);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EBatchTransfer";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(ARCU_DC_Packer.getURI(true));
        this.configFactory(factory);
        return factory;
    }
}

