/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.utils.CommumicationHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "batchQueryBalanceCurrent1_1Op";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest request) {
        String squence = Sequence.genSequence();
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"SUMU", (String)"1");
        Element opReqSet = new Element("opReqSet");
        Element opRequest = new Element("opRequest");
        JDomUtils.addChild((Element)opRequest, (String)"ACNO", (String)request.getHeader().getAcnt().getAccNo());
        JDomUtils.addChild((Element)opReqSet, (Element)opRequest);
        JDomUtils.addChild((Element)reqParam, (Element)opReqSet);
        String packAll = Packer.packAllInOne(squence, reqParam);
        packAll = JDomUtils.xml2XmlWithOutIndentLineSeparator((String)packAll, (String)CommumicationHelper.getEncoding4Comm());
        String session = LoginAndOut.login4GetSession();
        return Packer.getCommonBizReqData(session, "batchQueryBalanceCurrent1_1Op", packAll);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankAcnt acnt = request.getHeader().getAcnt();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if (!"0".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element root = JDomUtils.string2Root((String)responseStr, (String)"GBK");
        Element opRep = root.getChild("opRep");
        Element opResultSet = opRep.getChild("opResultSet");
        List list = opResultSet.getChildren();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < list.size(); ++i) {
            BalanceInfo balance = new BalanceInfo();
            try {
                Element opRequest = (Element)list.get(i);
                String ACNO = ParserUtils.getUnNullElementTextValue((Element)opRequest, (String)"ACNO", (String)ResManager.loadKDString((String)"\u8d26\u53f7", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
                String BIZH = ParserUtils.getUnNullElementTextValue((Element)opRequest, (String)"BIZH", (String)ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
                String YUER = ParserUtils.getUnNullElementTextValue((Element)opRequest, (String)"YUER", (String)ResManager.loadKDString((String)"\u8d26\u9762\u4f59\u989d", (String)"BalanceImpl_4", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
                String KYER = ParserUtils.getUnNullElementTextValue((Element)opRequest, (String)"KYER", (String)ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
                this.setBankAcnt(balance, request.getBankAcntList(), ACNO);
                this.setBankCurrency(balance, BIZH);
                this.setAvailableBalance(balance, KYER);
                this.setCurrentBalance(balance, YUER);
                balance.setBalanceDateTime(LocalDateTime.now());
            }
            catch (Exception e) {
                balance.setError(e.getMessage());
            }
            balanceInfos.add(balance);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }
}

