/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment.salary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.service.payment.salary.PayPacker;
import kd.ebg.aqap.banks.bosh.dc.service.payment.salary.PayParser;
import kd.ebg.aqap.banks.bosh.dc.service.payment.salary.QueryPaymentImpl;
import kd.ebg.aqap.banks.bosh.dc.service.sign.SignHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.BOSH_URLEncode;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.banks.bosh.dc.utils.SHA256;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SalaryPaymentImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(SalaryPaymentImpl.class);

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "APIUploadUNFileServlet";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u63a5\u53e3", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if (!"0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PayParser_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u94f6\u884c", (String)"PayParser_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(paymentInfos);
        return response;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) throws EBServiceException {
        List paymentInfos = request.getPaymentInfos();
        try {
            String charsetName = RequestContextUtils.getRequestContext().getCharsetName();
            if (StringUtils.isEmpty((String)charsetName)) {
                throw new EBServiceException(ResManager.loadKDString((String)"\u5f00\u53d1\u9519\u8bef\uff0c\u672a\u6307\u5b9a\u5b57\u7b26\u96c6\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
            }
            String rsqt = PayPacker.packPay(paymentInfos);
            String toSignStr = SHA256.signSHA256(rsqt.getBytes(charsetName));
            String bankBatchSeqId = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId();
            String session = LoginAndOut.login4GetSession();
            String signedPayMsg = SignHelper.sign(toSignStr, false);
            String sha = BOSH_URLEncode.encode(signedPayMsg);
            StringBuilder sb = new StringBuilder();
            sb.append("/CM/APIUploadUNFileServlet?dse_sessionId=").append(session).append("&serialNo=").append(bankBatchSeqId).append("&sha=").append(sha);
            ConnectionFactory factory = this.getConnectionFactory();
            factory.setHttpHeader("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            factory.setUri(sb.toString());
            IConnection conn = this.getConnection(factory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                String customerNo = RequestContextUtils.getBankParameterValue((String)"USER_ID");
                this.sendMsg(os, rsqt, customerNo + "_012_" + bankBatchSeqId + ".txt", "file");
                try (InputStream is = this.getInputStream(conn);){
                    String rsp = this.recv(is);
                    PayParser.parse(request, rsp);
                }
            }
            catch (Throwable t) {
                RequestContextUtils.getRequestContext().setThrowableAfterSend(t);
            }
        }
        catch (Exception e) {
            throw new EBServiceException((Throwable)e);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void sendMsg(OutputStream outputStream, String rqstStr, String filename, String fieldName) throws IOException {
        String charsetName = RequestContextUtils.getRequestContext().getCharsetName();
        if (StringUtils.isEmpty((String)charsetName)) {
            throw new EBBaseException(ResManager.loadKDString((String)"\u5f00\u53d1\u9519\u8bef\uff0c\u672a\u6307\u5b9a\u5b57\u7b26\u96c6\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
        }
        log.info("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u4e3a\uff1a" + filename);
        log.info("\u4e0a\u4f20\u7684\u6587\u4ef6\u5185\u5bb9\u4e3a");
        log.info(rqstStr);
        byte[] BOUNDARY_END = StrUtil.format((String)"--{}--\r\n", (Object[])new Object[]{BOUNDARY}).getBytes();
        String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
        String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n\r\n";
        StringBuilder builder = StrUtil.builder().append("--").append(BOUNDARY).append("\r\n");
        builder.append(StrUtil.format((String)CONTENT_DISPOSITION_FILE_TEMPLATE, (Object[])new Object[]{fieldName, filename}));
        builder.append(StrUtil.format((String)CONTENT_TYPE_FILE_TEMPLATE, (Object[])new Object[]{URLConnection.getFileNameMap().getContentTypeFor(filename)}));
        outputStream.write(builder.toString().getBytes(charsetName));
        outputStream.write(rqstStr.getBytes(charsetName));
        outputStream.write("\r\n".getBytes(charsetName));
        outputStream.write(BOUNDARY_END);
        outputStream.flush();
    }

    public int getBatchSize() {
        return 1000;
    }

    public boolean match(PaymentInfo info) {
        return "pay_for_salary".equals(info.getSubBizType());
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
        if (CommonUtil.isCFCA().booleanValue()) {
            factory.setHttpHeader("Content-Type-CFCA", "123456");
        }
    }
}

