/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.utils;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Codes {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Codes.class);
    private static Map shangHaiSameCityNames2Id = null;
    private static String[] names = null;
    private static Codes instance = null;
    private static final String CONFIG_FILE = "shanghaisamecity.xml";
    private long lastModiTime = -1L;

    private Codes() {
    }

    public static synchronized Codes instance() {
        if (null == instance) {
            instance = new Codes();
        }
        return instance;
    }

    public String getBCCD(PaymentInfo paymentInfo) {
        this.initShangHaiSameCity();
        String bankName = paymentInfo.getIncomeBankName();
        for (int i = 0; i < shangHaiSameCityNames2Id.size(); ++i) {
            if (-1 == bankName.indexOf(names[i])) continue;
            String bccd = (String)shangHaiSameCityNames2Id.get(names[i]);
            logger.info("\u81ea\u52a8\u5339\u914d\u63a5\u6536\u6e05\u7b97\u884c\u884c\u53f7:" + bankName + "(\u8f93\u5165) --> " + bccd + ":" + names[i] + "(\u884c\u53f7:\u884c\u540d)");
            return bccd;
        }
        logger.info("\u8be5\u94f6\u884c\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u5339\u914d\u4e0a\u76f8\u5e94\u6e05\u7b97\u884c\u884c\u53f7\uff0c\u6539\u4ece\u6570\u636e\u5e93\u4e2d\u67e5\u8be2");
        SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
        String clearBankNo = settBankKeyWordsRepository.matchBankNoByKey(bankName);
        if (StringUtils.isEmpty((String)clearBankNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u94f6\u884c%s\u7684\u63a5\u6536\u6e05\u7b97\u884c\u884c\u53f7\uff0c\u8bf7\u5728\u6e05\u7b97\u884c\u7ba1\u7406\u9875\u9762\u7ef4\u62a4\u6e05\u7b97\u884c\u53f7\u3002", (String)"Codes_5", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), bankName));
        }
        return clearBankNo;
    }

    private void initShangHaiSameCity() {
        try (InputStream is = this.getShangHaiSameCityConfigAsIS();){
            String content = IOUtils.readFully((InputStream)is, (String)"UTF-8");
            shangHaiSameCityNames2Id = new HashMap(16);
            Element root = JDomUtils.string2Root((String)content, (String)"UTF-8");
            List list = root.getChildren("bank");
            names = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String name;
                Element bank = (Element)list.get(i);
                String id = bank.getChildText("id");
                Codes.names[i] = name = bank.getChildText("name");
                shangHaiSameCityNames2Id.put(name, id);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4e0a\u6d77\u540c\u57ce\u4ea4\u6362\u6570\u636e(\u63a5\u6536\u6e05\u7b97\u884c\u884c\u53f7)\u5f02\u5e38\u3002", (String)"Codes_3", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private InputStream getShangHaiSameCityConfigAsIS() {
        InputStream inputStream = null;
        try {
            inputStream = Codes.class.getClassLoader().getResourceAsStream(CONFIG_FILE);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6shanghaisamecity.xml\u6587\u4ef6,\u8bf7\u5728configs\u76ee\u5f55\u4e0b\u914d\u7f6e.", (String)"Codes_4", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return inputStream;
    }
}

