/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.fjhxb.dc.services.payment.salary;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.fjhxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Packer;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Parser;
import kd.ebg.aqap.banks.fjhxb.dc.services.FJHXB_Util;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 200;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)FJHXB_Packer.buildHead("B2ESalaryPayQry", Sequence.genSequence()));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        if (StringUtils.isEmpty((String)((PaymentInfo)paymentInfos.get(0)).getBankRefID())) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u94f6\u884c\u6d41\u6c34\u53f7\u4e3a\u7a7a,\u65e0\u6cd5\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001,\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u5b9a\u4ed8\u6b3e\u72b6\u6001", (String)"SalaryQueryImpl_5", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"BatchId", (String)((PaymentInfo)paymentInfos.get(0)).getBankRefID());
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        String date = ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)date);
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)date);
        JDomUtils.addChild((Element)body, (String)"SalEntNo", (String)BankBusinessConfig.getSalaryCode(((PaymentInfo)paymentInfos.get(0)).getAccNo()));
        return JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List<PaymentInfo> paymentInfos = bankPayRequest.getPaymentInfos();
        Element bank_root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        Element body = bank_root.getChild("Body");
        BankResponse headRsp = FJHXB_Parser.parserCommonInfo(bank_root);
        String bankStatus = headRsp.getResponseCode();
        if (!FJHXB_Util.SUCCESS_CODE.equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"SalaryQueryImpl_0", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), headRsp.getResponseMessage());
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryImpl_1", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)bankStatus, (String)errorMsg);
            return new EBBankPayResponse((List)paymentInfos);
        }
        Element Map2 = body.getChild("List").getChild("Map");
        String FailMsg = Map2.getChildText("FailMsg");
        String AgentState = Map2.getChildText("AgentState");
        if ("00".equals(AgentState) || "10".equals(AgentState)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryImpl_2", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)bankStatus, (String)FailMsg);
        } else {
            List lists = Map2.getChild("List").getChildren("Map");
            if (lists.size() > 0) {
                paymentInfos = this.preBatchSameItemCheck(bankPayRequest);
                for (Element element : lists) {
                    String amount;
                    String accNo = element.getChildText("EmpAcNo");
                    PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)accNo, (BigDecimal)new BigDecimal(amount = element.getChildText("EmpAmount")));
                    if (paymentInfo == null) continue;
                    String returnCode = JDomUtils.getChildText((Element)element, (String)"DisposalRes");
                    String msg = JDomUtils.getChildText((Element)element, (String)"FailedReason");
                    this.handlePayStatus(paymentInfo, returnCode, msg);
                }
                this.processingBankItemDataHandler(lists);
                PayStatusMatchUtil.backBatchSameItemHandler((List)bankPayRequest.getPaymentInfos(), (boolean)false, (boolean)false);
            }
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    private List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public void processingBankItemDataHandler(List<Element> elementList) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (Element element : elementList) {
                    String bankDataKey = this.getBankDataKey(element);
                    if (!HashSetKeys.contains(bankDataKey)) continue;
                    String returnCode = JDomUtils.getChildText((Element)element, (String)"DisposalRes");
                    String msg = JDomUtils.getChildText((Element)element, (String)"FailedReason");
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    this.handlePayStatus(tempInfo, returnCode, msg);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public PaymentInfo handlePayStatus(PaymentInfo tempInfo, String returnCode, String msg) {
        if ("02".equals(returnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryImpl_3", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)returnCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryImpl_3", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]));
        } else if ("01".equals(returnCode) || "04".equals(returnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryImpl_4", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)returnCode, (String)msg);
        } else if ("00".equals(returnCode) || "03".equals(returnCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryImpl_2", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)returnCode, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryImpl_1", (String)"ebg-aqap-banks-fjhxb-dc", (Object[])new Object[0]), (String)returnCode, (String)msg);
        }
        return tempInfo;
    }

    private String getBankDataKey(Element element) {
        String incomeNo = element.getChildText("EmpAcNo");
        String incomeName = element.getChildText("EmpAcName");
        String amount = element.getChildText("EmpAmount");
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(incomeNo).append(incomeName).append(new BigDecimal(amount).setScale(2).toString());
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getAmountErrorFormatTips(), (Throwable)e);
        }
        return buffer.toString();
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ESalaryPayQry";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/B2ESalaryPayQry.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=1";
        factory.setUri(s);
        super.configFactory(factory);
    }
}

