/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ghb.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ghb.dc.services.utils.GHB_DC_Packer;
import kd.ebg.aqap.banks.ghb.dc.services.utils.GHB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest rqst) {
        BankAcnt bankAcnt = rqst.getAcnt();
        String transCode = "ZTSA63Q02";
        String encoding = RequestContextUtils.getCharset();
        Element root = GHB_DC_Packer.createHead(Sequence.gen18Sequence(), transCode);
        JDomUtils.addChild((Element)root, (String)"ACCTNO", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)root, (String)"CCY", (String)rqst.getBankCurrency());
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        Element root = GHB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = GHB_DC_Parser.parseResponse(root);
        BankAcnt bankAcnt = rqst.getAcnt();
        ParserUtils.checkRspCode((BankAcnt)bankAcnt, (String)ResManager.loadKDString((String)"\u8d26\u6237\u57fa\u672c\u4fe1\u606f\u67e5\u8be2", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]), (BankResponse)response, (String)"000000");
        List list = root.getChildren("ROW");
        BigDecimal balance = new BigDecimal("0.0");
        BigDecimal aviBalance = new BigDecimal("0.0");
        Boolean existSameCurBal = false;
        for (int i = 0; i < list.size(); ++i) {
            Element row = (Element)list.get(i);
            String balanceStr = row.getChildTextTrim("ACCTBAL");
            String aviBalanceStr = row.getChildTextTrim("AVAILABLEBAL");
            String currencyCode = ParserUtils.checkUnNullableElement((Element)row, (String)"CCY");
            if (!(StringUtils.isNotEmpty((String)currencyCode) & rqst.getBankCurrency().equals(currencyCode))) continue;
            balance = balance.add(BigDecimalHelper.str2BigDecimalForBalance((String)balanceStr, (Boolean)false));
            if (StringUtils.isNotEmpty((String)aviBalanceStr)) {
                aviBalance = aviBalance.add(new BigDecimal(aviBalanceStr));
            }
            existSameCurBal = true;
        }
        if (!existSameCurBal.booleanValue()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6ca1\u6709\u8fd4\u56de\u548c\u8bf7\u6c42\u5e01\u522b\u4e00\u81f4\u7684\u4f59\u989d", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]));
        }
        BalanceInfo balanceinfo = new BalanceInfo();
        balanceinfo.setBalanceDateTime(LocalDateTime.now());
        balanceinfo.setBankAcnt(rqst.getAcnt());
        balanceinfo.setBankCurrency(rqst.getBankCurrency());
        balanceinfo.setCurrentBalance(balance);
        balanceinfo.setAvailableBalance(aviBalance);
        return new EBBankBalanceResponse(Collections.singletonList(balanceinfo));
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/ghbankgayway4ent/rest/gayway";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "application/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "ZTSA63Q02";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-ghb-dc", (Object[])new Object[0]);
    }
}

