/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ecny.services.ecny.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ecny.services.CCB_DC_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceParser.class);

    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = CCB_DC_Parser.parseString2Root(rspStr);
        BankResponse response = CCB_DC_Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankResponse)response, (String)"000000");
        Element txInfo = root.getChild("TX_INFO");
        String balanceStr = ParserUtils.checkUnNullableElement((Element)txInfo, (String)"AcBa");
        String aviBalanceStr = ParserUtils.checkUnNullableElement((Element)txInfo, (String)"Avl_Bal");
        BalanceInfo balance = new BalanceInfo();
        balance.setBalanceDateTime(LocalDateTime.now());
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(rqst.getAcnt().getAccNo());
        balance.setBankAcnt(bankAcnt);
        if (StringUtils.isEmpty((String)balanceStr)) {
            ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-ccb-ecny", (Object[])new Object[0]);
        }
        balance.setBankCurrency(rqst.getBankCurrency());
        this.log.info("\u4f59\u989d\u4fe1\u606f:,\u4f59\u989d:" + balanceStr + ",\u53ef\u7528\u989d\u5ea6:" + aviBalanceStr);
        try {
            balance.setCurrentBalance(new BigDecimal(balanceStr));
            balance.setAvailableBalance(new BigDecimal(aviBalanceStr));
        }
        catch (Exception e) {
            EBServiceException ex = EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8bbe\u7f6e\u8d26\u6237\u4f59\u989d\u51fa\u9519\u3002", (String)"TodayBalanceParser_0", (String)"ebg-aqap-banks-ccb-ecny", (Object[])new Object[0]), (Throwable)e);
            this.log.error(ex.getMessage());
            throw ex;
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
    }
}

