/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ecny.services.ecny.detail;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.ccb.ecny.services.CCB_DC_Packer;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPacker {
    public String packHisDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        return this.packDetail(rqst, pageTag);
    }

    public String packTodayDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        return this.packDetail(rqst, pageTag);
    }

    private String packDetail(BankDetailRequest rqst, String pageTag) throws EBServiceException {
        BankAcnt acnt = rqst.getAcnt();
        String request_sn = Sequence.gen16NumSequence() + "";
        Element header = CCB_DC_Packer.createTransactionHeader("NWXM02", request_sn);
        Element txInfo = new Element("TX_INFO");
        JDomUtils.addChild((Element)txInfo, (String)"Wlt_ID", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)txInfo, (String)"StDt", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)txInfo, (String)"EdDt", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        int index = pageTag.indexOf("_");
        JDomUtils.addChild((Element)txInfo, (String)"PAGE", (String)pageTag.substring(0, index));
        JDomUtils.addChild((Element)txInfo, (String)"REC_IN_PAGE", (String)"100");
        return CCB_DC_Packer.packAll2XML(header, txInfo);
    }
}

