/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ZJRC_DC_Packer {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ZJRC_DC_Packer.class);
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter DETAIL_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH.mm.ss");

    public static String formatDate(LocalDate localDate) {
        return localDate.format(DATE_FORMATTER);
    }

    public static Element getCommonHeader(String code, String seqNo) {
        Element root = JDomUtils.createRoot((String)"ebank");
        Element reqHead = JDomUtils.addChild((Element)root, (String)"reqHead");
        JDomUtils.addChild((Element)reqHead, (String)"custNo", (String)RequestContextUtils.getBankParameterValue((String)"CORP_NO"));
        JDomUtils.addChild((Element)reqHead, (String)"userId", (String)RequestContextUtils.getBankParameterValue((String)"OpNo"));
        JDomUtils.addChild((Element)reqHead, (String)"tranCode", (String)code);
        JDomUtils.addChild((Element)reqHead, (String)"serialNo", (String)seqNo);
        Date now = new Date();
        JDomUtils.addChild((Element)reqHead, (String)"reqDate", (String)DateUtil.formatDate((Date)now));
        JDomUtils.addChild((Element)reqHead, (String)"reqTime", (String)new SimpleDateFormat("HHmmssSSS").format(now));
        return root;
    }

    public static String getPostParams(Element root, String transCode) {
        String params = "tranCode=" + transCode + "&url=" + RequestContextUtils.getBankParameterValue((String)"signProtocol") + "://" + RequestContextUtils.getBankParameterValue((String)"SING_SERVER_IP") + ":" + RequestContextUtils.getBankParameterValue((String)"signPort") + "/" + RequestContextUtils.getBankParameterValue((String)"BANK_REQUST_URI") + "&transData=";
        String charset = RequestContextUtils.getCharset();
        String requestStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)charset);
        logger.info("\u4ea4\u6613\u7801\uff1a{}-\u8bf7\u6c42\u53c2\u6570\u660e\u6587\uff1a{}", new Object[]{transCode, requestStr});
        String content = null;
        try {
            content = URLEncoder.encode(requestStr, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%s\u5b57\u7b26\u96c6\u4e0d\u652f\u6301\u3002", (String)"ZJRC_DC_Packer_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), charset), (Throwable)e);
        }
        return params + content;
    }

    @Deprecated
    public static String packSignXML(String reqStr, String encoding) {
        Element root = JDomUtils.createRoot((String)"msg");
        Element msg_head = JDomUtils.addChild((Element)root, (String)"msg_head");
        JDomUtils.addChild((Element)msg_head, (String)"msg_type", (String)"0");
        JDomUtils.addChild((Element)msg_head, (String)"msg_id", (String)"1005");
        JDomUtils.addChild((Element)msg_head, (String)"msg_sn", (String)"0");
        JDomUtils.addChild((Element)msg_head, (String)"version", (String)"1");
        Element msg_body = JDomUtils.addChild((Element)root, (String)"msg_body");
        JDomUtils.addChild((Element)msg_body, (String)"origin_data_len", (String)("" + reqStr.length()));
        JDomUtils.addChild((Element)msg_body, (String)"origin_data", (String)reqStr);
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)encoding);
    }
}

