/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.company;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.BankResponseCodeUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest request) {
        Element root = ZJRC_DC_Packer.getCommonHeader("100009", Sequence.genSequence());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"flowNoType", (String)"1");
        Element flowNoList = JDomUtils.addChild((Element)reqBody, (String)"flowNoList");
        Element row = JDomUtils.addChild((Element)flowNoList, (String)"row");
        JDomUtils.addChild((Element)row, (String)"orderFlowNo", (String)((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqId());
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        List paymentInfos = request.getPaymentInfos();
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"CompanyQueryPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
            Element tranflowResultList = JDomUtils.getChildElement((Element)resBody, (String)"tranflowResultList");
            List rows = tranflowResultList.getChildren("row");
            String code = JDomUtils.getChildText((Element)((Element)rows.get(0)), (String)"state");
            String erroerMsg = JDomUtils.getChildText((Element)((Element)rows.get(0)), (String)"errorMessage");
            if (BankResponseCodeUtils.isSuccessed(code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)BankResponseCodeUtils.getResponseMsg(code), (String)code, (String)erroerMsg);
            } else if (BankResponseCodeUtils.isFailed(code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)BankResponseCodeUtils.getResponseMsg(code), (String)code, (String)erroerMsg);
            } else if (BankResponseCodeUtils.isSubmit(code)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)code, (String)erroerMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)BankResponseCodeUtils.getResponseMsg(code), (String)code, (String)erroerMsg);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100009";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u652f\u4ed8\u67e5\u8be2", (String)"CompanyQueryPayImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }
}

