/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjrc.dc.services.payment.individual;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Packer;
import kd.ebg.aqap.banks.zjrc.dc.services.ZJRC_DC_Parser;
import kd.ebg.aqap.banks.zjrc.dc.services.payment.BankResponseCodeUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 500;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ZJRC_DC_Packer.getCommonHeader("100010", Sequence.genSequence());
        Element reqBody = JDomUtils.addChild((Element)root, (String)"reqBody");
        JDomUtils.addChild((Element)reqBody, (String)"flowNoType", (String)"1");
        JDomUtils.addChild((Element)reqBody, (String)"batchNo", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        return ZJRC_DC_Packer.getPostParams(root, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZJRC_DC_Parser.parserCommonInfo(root);
        if (!bankResponse.getResponseCode().equals("0000")) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u5f02\u5e38", (String)"IndividualQueryPayImpl_0", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            Element resBody = JDomUtils.getChildElement((Element)root, (String)"resBody");
            String batchNo = JDomUtils.getChildText((Element)resBody, (String)"batchNo");
            String payAccount = JDomUtils.getChildText((Element)resBody, (String)"payAccount");
            String batchErrorMessage = JDomUtils.getChildText((Element)resBody, (String)"batchErrorMessage");
            if (!batchNo.equalsIgnoreCase(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID()) || !payAccount.equals(((PaymentInfo)paymentInfos.get(0)).getAccNo())) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u65e0\u6cd5\u5339\u914d\u6279\u6b21\u53f7\uff0c\u6216\u65e0\u6cd5\u5339\u914d\u8d26\u53f7\u3002", (String)"IndividualQueryPayImpl_1", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
            }
            String batchStt = JDomUtils.getChildText((Element)resBody, (String)"batchStt");
            if (BankResponseCodeUtils.isSuccessed(batchStt)) {
                Element tranflowResultList = JDomUtils.getChildElement((Element)resBody, (String)"wageflowResultList");
                List rows = tranflowResultList.getChildren("row");
                HashMap detailMap = Maps.newHashMapWithExpectedSize((int)16);
                for (Element element : rows) {
                    String recAccount = JDomUtils.getChildText((Element)element, (String)"recAccount");
                    String recAccountName = JDomUtils.getChildText((Element)element, (String)"recAccountName");
                    String empNo = JDomUtils.getChildText((Element)element, (String)"empNo");
                    String amount = JDomUtils.getChildText((Element)element, (String)"amount");
                    String state = JDomUtils.getChildText((Element)element, (String)"state");
                    String errorMessage = JDomUtils.getChildText((Element)element, (String)"errorMessage");
                    PaymentInfo paymentInfo = new PaymentInfo();
                    paymentInfo.setIncomeAccNo(recAccount);
                    paymentInfo.setIncomeAccName(recAccountName);
                    paymentInfo.setAmount(new BigDecimal(amount));
                    paymentInfo.setBankStatus(state);
                    paymentInfo.setErrorMsg(errorMessage);
                    detailMap.put(empNo, paymentInfo);
                }
                this.setEBGBussinessState(detailMap, paymentInfos);
            } else if (BankResponseCodeUtils.isFailed(batchStt)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)batchErrorMessage, (String)batchStt, (String)BankResponseCodeUtils.getResponseMsg(batchStt));
            } else if (BankResponseCodeUtils.isSubmit(batchStt)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)batchStt, (String)"");
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)batchErrorMessage, (String)batchStt, (String)BankResponseCodeUtils.getResponseMsg(batchStt));
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void setEBGBussinessState(Map<String, PaymentInfo> detailMap, List<PaymentInfo> paymentInfos) {
        for (int i = 0; i < paymentInfos.size(); ++i) {
            if (detailMap.containsKey(paymentInfos.get(i).getBankDetailSeqId())) {
                PaymentInfo paymentInfo = detailMap.get(paymentInfos.get(i).getBankDetailSeqId());
                String state = paymentInfo.getBankStatus();
                String errorString = paymentInfo.getErrorMsg();
                if (BankResponseCodeUtils.isSuccessed(state)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.SUCCESS, (String)BankResponseCodeUtils.getResponseMsg(state), (String)state, (String)errorString);
                    continue;
                }
                if (BankResponseCodeUtils.isFailed(state)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.FAIL, (String)BankResponseCodeUtils.getResponseMsg(state), (String)state, (String)errorString);
                    continue;
                }
                if (BankResponseCodeUtils.isSubmit(state)) {
                    EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)state, (String)errorString);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)BankResponseCodeUtils.getResponseMsg(state), (String)state, (String)errorString);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos.get(i), (PaymentState)PaymentState.UNKNOWN, (String)"", (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5e8f\u53f7\u4e0d\u5339\u914d\uff0c\u72b6\u6001\u672a\u77e5\u3002", (String)"IndividualQueryPayImpl_2", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u660e\u7ec6\u5e8f\u53f7\u4e0d\u5339\u914d\uff0c\u72b6\u6001\u672a\u77e5\u3002", (String)"IndividualQueryPayImpl_3", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]));
        }
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "100010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u79c1\u4ed8\u6b3e\u67e5\u8be2\u3002", (String)"IndividualQueryPayImpl_4", (String)"ebg-aqap-banks-zjrc-dc", (Object[])new Object[0]);
    }
}

