/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gxnx.cmp.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gxnx.cmp.services.utils.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/corporbank/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        String page = currentPage.equalsIgnoreCase("0") ? "1" : currentPage;
        String detailStr = Packer.packDetail(bankDetailRequest, page);
        return "CBE006|#" + detailStr;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        String currentPage = this.getCurrentPage();
        int nextPage = Integer.parseInt(currentPage) + 20;
        this.setCurrentPage(String.valueOf(nextPage));
        int index = rspStr.indexOf("#");
        String[] split = rspStr.substring(0, index).split("\\|");
        String responseCode = split[0];
        if (!"0000".equalsIgnoreCase(responseCode)) {
            String responseMsg = split[1];
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s \u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]), responseCode, responseMsg));
        }
        String body = rspStr.substring(index + 1);
        body = Packer.decodeResponse(body);
        Element root = JDomUtils.string2Root((String)body, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String turnPageTotalQnt = JDomUtils.getChildText((Element)opRep, (String)"turnPageTotalQnt");
        if (nextPage >= Integer.parseInt(turnPageTotalQnt)) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
        }
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Element list = JDomUtils.getChildElementNotNull((Element)opResult, (String)"list");
        List row = list.getChildren();
        ArrayList<DetailInfo> results = new ArrayList<DetailInfo>(20);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (int i = 0; i < row.size(); ++i) {
            Element element = (Element)row.get(i);
            String currencyType = JDomUtils.getChildText((Element)element, (String)"currencyType");
            String loanFlag = JDomUtils.getChildText((Element)element, (String)"loanFlag");
            String cadDebit = JDomUtils.getChildText((Element)element, (String)"cadDebit");
            String cadCredit = JDomUtils.getChildText((Element)element, (String)"cadCredit");
            String balance = JDomUtils.getChildText((Element)element, (String)"balance");
            String oppositeAccount = JDomUtils.getChildText((Element)element, (String)"oppositeAccount");
            String oppositeAccountName = JDomUtils.getChildText((Element)element, (String)"oppositeAccountName");
            String transferDate = JDomUtils.getChildText((Element)element, (String)"transferDate");
            String remark = JDomUtils.getChildText((Element)element, (String)"remark");
            DetailInfo info = new DetailInfo();
            info.setAccNo(acnt.getAccNo());
            info.setAccName(acnt.getAccName());
            info.setBankName(acnt.getBankName());
            info.setCurrency(currencyType);
            if (!StringUtils.isEmpty((String)balance)) {
                info.setBalance(new BigDecimal(balance));
            }
            String payAmount = "0";
            if ("D".equalsIgnoreCase(loanFlag)) {
                info.setDebitAmount(new BigDecimal(cadDebit));
                info.setCreditAmount(BigDecimal.ZERO);
                payAmount = cadDebit;
            } else if ("C".equalsIgnoreCase(loanFlag)) {
                info.setCreditAmount(new BigDecimal(cadCredit));
                info.setDebitAmount(BigDecimal.ZERO);
                payAmount = cadCredit;
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u501f\u8d37\u6807\u8bc6\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]));
            }
            info.setOppAccNo(oppositeAccount);
            info.setOppAccName(oppositeAccountName);
            info.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            info.setTransTime(LocalDateTime.parse(transferDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            info.setExplanation(remark);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("payAmount", (Object)payAmount);
            jsonStr = jsonObject.toJSONString();
            info.setJsonMap(jsonStr);
            String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transferDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            info.setReceiptNo(receiptNo);
            results.add(info);
        }
        return new EBBankDetailResponse(results);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u53f7\u5f53\u65e5/\u5386\u53f2\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-gxnx-cmp", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

