/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hbnxs.dc.services.utils;

import java.util.Date;
import kd.ebg.aqap.banks.hbnxs.dc.services.utils.DESUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HBNXS_headPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HBNXS_headPacker.class);
    public static final String CONFIG_PROPERTIES_CERT_KEY = "clientKey";

    public static Element buildHead(String req_no, String txcode) {
        Element root = JDomUtils.createRoot((String)"root");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        Date date = new Date();
        JDomUtils.addChild((Element)head, (String)"SendDate", (String)DateUtil.formatDate((Date)date));
        JDomUtils.addChild((Element)head, (String)"SendTime", (String)DateUtil.formatTime((Date)date));
        JDomUtils.addChild((Element)head, (String)"SendSeqNo", (String)req_no);
        JDomUtils.addChild((Element)head, (String)"SendNode", (String)RequestContextUtils.getParameter().getBankParameter("CORP_NO"));
        JDomUtils.addChild((Element)head, (String)"TxCode", (String)txcode);
        JDomUtils.addChild((Element)head, (String)"OperNo", (String)"");
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        return root;
    }

    public static String getMsg(Element root, String trancode) {
        StringBuilder buffer = new StringBuilder();
        String str = JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
        String custno = RequestContextUtils.getParameter().getBankParameter("CORP_NO");
        String key = HBNXS_headPacker.getKey();
        if (StringUtils.isEmpty((String)key)) {
            buffer.append(custno);
            buffer.append(trancode);
            buffer.append("0");
            buffer.append("0000000");
            buffer.append(HBNXS_headPacker.getLength(str));
            buffer.append(str);
        } else {
            logger.info("\u5f00\u59cb\u52a0\u5bc6\u64cd\u4f5c\u52a0\u5bc6:" + str);
            buffer.append(custno);
            buffer.append(trancode);
            buffer.append("1");
            buffer.append("0000000");
            String strencode = DESUtil.encode3Des(key, str);
            buffer.append(HBNXS_headPacker.getLength(strencode));
            buffer.append(strencode);
        }
        return buffer.toString();
    }

    private static String getKey() {
        return DESUtil.getCA("priSecret");
    }

    private static String getLength(String str) {
        String result = "";
        String length = str.length() + "";
        if (length.length() == 0) {
            result = "000000";
        } else if (length.length() == 1) {
            result = "00000" + length;
        } else if (length.length() == 2) {
            result = "0000" + length;
        } else if (length.length() == 3) {
            result = "000" + length;
        } else if (length.length() == 4) {
            result = "00" + length;
        } else if (length.length() == 5) {
            result = "0" + length;
        } else if (length.length() == 6) {
            result = length + "";
        }
        return result;
    }
}

