/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srb.cmp.services.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.srb.cmp.services.utils.Common;
import kd.ebg.aqap.banks.srb.cmp.services.utils.FileUtil;
import kd.ebg.aqap.banks.srb.cmp.services.utils.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200110";
        Element ap = Packer.createCommonHead(tr_code, req_no, "0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg(xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        FileUtil fileUtil = new FileUtil();
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(1);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)s, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse(head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if (StringUtils.isEmpty((String)record_num) || "0".equals(record_num)) {
            log.error("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
            return new EBBankDetailResponse(details);
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String file_flag = head.getChildTextTrim("file_flag");
        String content = "";
        if ("1".equals(file_flag)) {
            log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                content = fileUtil.downloadFile(file_name);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u62a5\u6587'");
            content = body.getChildTextTrim("serial_record");
        }
        log.info("\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u660e\u7ec6\u5185\u5bb9\uff1a" + content);
        List<Map<String, String>> detailList = this.parseRecord(content, recordNum, fieldNum);
        BankAcnt acnt = bankDetailRequest.getAcnt();
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int k = 0; k < detailList.size(); ++k) {
            Map<String, String> recordMap = detailList.get(k);
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(acnt.getAccNo());
            detailInfo.setAccName(acnt.getAccName());
            detailInfo.setBankName(acnt.getBankName());
            detailInfo.setOppAccNo(recordMap.get("opp_acno"));
            detailInfo.setOppAccName(recordMap.get("opp_acname"));
            detailInfo.setOppBankName(recordMap.get("opp_bankname"));
            detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
            String transTime = recordMap.get("tr_acdt") + recordMap.get("tr_time");
            LocalDateTime tdt = LocalDateTime.parse(transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detailInfo.setTransTime(tdt);
            detailInfo.setTransDate(tdt.toLocalDate());
            String cdFlag = recordMap.get("crdr_flag");
            if ("D".equals(cdFlag)) {
                detailInfo.setDebitAmount(new BigDecimal(recordMap.get("amt")));
                detailInfo.setCreditAmount(new BigDecimal("0"));
            } else if ("C".equals(cdFlag)) {
                detailInfo.setDebitAmount(new BigDecimal("0"));
                detailInfo.setCreditAmount(new BigDecimal(recordMap.get("amt")));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u5fd7crdr_flag\u4e3a%s\u3002", (String)"DetailImpl_5", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), cdFlag));
            }
            detailInfo.setExplanation(recordMap.get("remark"));
            if (!StringUtils.isEmpty((String)recordMap.get("balance"))) {
                detailInfo.setBalance(new BigDecimal(recordMap.get("balance")));
            }
            String host_serial_no = recordMap.get("host_serial_no");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tr_acdt", (Object)recordMap.get("tr_acdt"));
            jsonObject.put("crdr_flag", (Object)cdFlag);
            jsonObject.put("amt", (Object)recordMap.get("amt"));
            jsonObject.put("host_serial_no", (Object)host_serial_no);
            jsonObject.put("opp_acno", (Object)recordMap.get("opp_acno"));
            detailInfo.setJsonMap(jsonObject.toString());
            detailInfo.setBankDetailNo(host_serial_no);
            String receiptNo = MatchRule.getInstance().getReceiptNo(acnt.getAccNo(), recordMap.get("tr_acdt"), jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            details.add(detailInfo);
        }
        log.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===");
        return new EBBankDetailResponse(details);
    }

    public List<Map<String, String>> parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[] fieldNames = new String[fieldNum];
        System.arraycopy(allrecord, 0, fieldNames, 0, fieldNum);
        ArrayList<Map<String, String>> detaiList = new ArrayList<Map<String, String>>(3);
        for (int i = 0; i < recordNum; ++i) {
            HashMap<String, String> recordMap = new HashMap<String, String>(3);
            for (int j = 0; j < fieldNum; ++j) {
                recordMap.put(fieldNames[j], allrecord[(i + 1) * fieldNum + j]);
            }
            detaiList.add(recordMap);
        }
        return detaiList;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6(200110\u4ea4\u6613)", (String)"DetailImpl_3", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg(super.recv(inputStream));
    }
}

