/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.srb.cmp.services.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ParserUtil {
    public static List<PaymentInfo> preBatchSameItemCheck(BankPayRequest request) {
        List paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
        request.setPaymentInfos(paymentInfos);
        PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
        return paymentInfos;
    }

    public static void processingBankItemDataHandler(String[][] rs) {
        EBContext context = EBContext.getContext();
        Map batchQueryPayTempData = (Map)context.getResult();
        if (batchQueryPayTempData != null) {
            Set HashSetKeys = (Set)batchQueryPayTempData.get("HashSetKeys");
            if (HashSetKeys.size() > 0) {
                HashMap<String, ArrayList<PaymentInfo>> bankDataMap = (HashMap<String, ArrayList<PaymentInfo>>)batchQueryPayTempData.get("bankDateMap");
                if (bankDataMap == null) {
                    bankDataMap = new HashMap<String, ArrayList<PaymentInfo>>(16);
                }
                for (int i = 0; i < rs.length; ++i) {
                    BigDecimal amount;
                    String bankDataKey;
                    String ACNO = rs[i][1];
                    String ACNAME = rs[i][3];
                    String AMT = rs[i][5];
                    if (StringUtils.isEmpty((String)AMT) || !HashSetKeys.contains(bankDataKey = ParserUtil.getBankDataKey(ACNO, ACNAME, (amount = new BigDecimal(AMT).setScale(2)).toPlainString()))) continue;
                    String STAT = rs[i][9];
                    String ERR_MSG = rs[i][10];
                    PaymentInfo tempInfo = new PaymentInfo();
                    tempInfo.setToGiveUp(Boolean.valueOf(false));
                    ParserUtil.handlePayStatus(tempInfo, STAT, ERR_MSG);
                    ArrayList<PaymentInfo> tempList = (ArrayList<PaymentInfo>)bankDataMap.get(bankDataKey);
                    if (tempList == null) {
                        tempList = new ArrayList<PaymentInfo>(16);
                    }
                    tempList.add(tempInfo);
                    bankDataMap.put(bankDataKey, tempList);
                    batchQueryPayTempData.put("bankDateMap", bankDataMap);
                }
            }
            context.setResult((Object)batchQueryPayTempData);
        }
    }

    public static String getBankDataKey(String accNo, String name, String amount) {
        StringBuilder result = new StringBuilder();
        result.append(accNo).append(name).append(amount);
        return result.toString();
    }

    public static void handlePayStatus(PaymentInfo payInfo, String STAT, String ERR_MSG) {
        if ("9".equals(STAT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySalaryPaymentImpl_3", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QrySalaryPaymentImpl_3", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]));
        } else if ("6".equals(STAT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QrySalaryPaymentImpl_4", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        } else if ("0".equals(STAT) || "2".equals(STAT) || "3".equals(STAT) || "4".equals(STAT) || "5".equals(STAT) || "8".equals(STAT) || "A".equals(STAT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QrySalaryPaymentImpl_5", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QrySalaryPaymentImpl_0", (String)"ebg-aqap-banks-srb-cmp", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        }
    }
}

