/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.individual;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.services.payment.AbstractBatchQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BankResponseResult;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class IndividualQueryPayImpl
extends AbstractBatchQueryPayImpl
implements IQueryPay,
HXB_DC_Constants {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(IndividualQueryPayImpl.class);

    public int getBatchSize() {
        return 50;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "xhj1002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u3002", (String)"IndividualQueryPayImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        StringBuilder sb = new StringBuilder();
        sb.append("xhj1002");
        sb.append('#');
        sb.append(paymentInfo.getAccNo());
        sb.append('#');
        String testTime = EBContext.getContext().getParameter().getBankParameter("TEST_TIME");
        if (!StringUtils.isEmpty((String)testTime)) {
            sb.append(testTime);
        } else {
            sb.append(paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        sb.append('#');
        sb.append(paymentInfo.getPackageId());
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        List paymentInfos = request.getPaymentInfos();
        String responseCode = elements[0];
        if ("000000".equalsIgnoreCase(responseCode)) {
            paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
            request.setPaymentInfos(paymentInfos);
            PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
            Map<String, BankResponseResult> bankResponseMap = this.getBankResult(elements);
            for (PaymentInfo info : paymentInfos) {
                String id = info.getIncomeAccNo() + info.getIncomeAccName() + info.getAmount().toString();
                BankResponseResult result = bankResponseMap.get(id);
                if (null == result) continue;
                this.handlePayStatus(info, result.getResponseCode(), result.getBankMessage());
            }
            this.processingBankItemDataHandler(elements);
            PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos, (boolean)false, (boolean)false);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private Map<String, BankResponseResult> getBankResult(String[] records) {
        HashMap<String, BankResponseResult> resultMap = new HashMap<String, BankResponseResult>(16);
        int length = records.length;
        int limit = length - 1;
        for (int i = this.detailIndex(); i < limit; ++i) {
            String record = records[i];
            String[] details = StringUtils.split((String)record, (String)"|");
            if (details.length < this.detailSize()) continue;
            String status = details[4];
            String statusMsg = details[5];
            BankResponseResult result = new BankResponseResult(status);
            result.setBankMessage(statusMsg);
            result.setSuccessCodes(new String[]{"0"});
            result.setFailedCodes(new String[]{"2"});
            result.setId(this.getBankDataKey(details));
            resultMap.put(result.getId(), result);
        }
        return resultMap;
    }

    @Override
    public String getBankDataKey(String[] details) {
        String incomeNO = details[1];
        String incomeName = details[2];
        String incomeAmount = details[3];
        return incomeNO + incomeName + new BigDecimal(incomeAmount).setScale(2);
    }

    @Override
    public void handlePayStatus(PaymentInfo tempInfo, String[] details) {
        String status = details[4];
        String statusMsg = details[5];
        this.handlePayStatus(tempInfo, status, statusMsg);
    }

    private void handlePayStatus(PaymentInfo tempInfo, String status, String statusMsg) {
        if ("0".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"IndividualQueryPayImpl_3", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)statusMsg);
        } else if ("2".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualQueryPayImpl_4", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)statusMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualQueryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)statusMsg);
        }
    }

    @Override
    public int detailSize() {
        return 6;
    }

    @Override
    public int detailIndex() {
        return 8;
    }
}

