/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.salary.OutterBank;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.services.payment.AbstractBatchQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.PayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SalaryQueryPayImpl
extends AbstractBatchQueryPayImpl
implements IQueryPay,
HXB_DC_Constants {
    public static EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public int getBatchSize() {
        return 1000;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "xhj5002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u8f6c\u8d26\u4ea4\u6613\u7ed3\u679c\u67e5\u8be2\u3002", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymenInfo = paymentInfos[0];
        StringBuilder sb = new StringBuilder();
        sb.append("xhj5002");
        sb.append('#');
        String testTime = EBContext.getContext().getParameter().getBankParameter("TEST_TIME");
        if (!StringUtils.isEmpty((String)testTime)) {
            sb.append(testTime);
        } else {
            sb.append(paymenInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        sb.append('#');
        String flow_no = PaymentInfoSysFiled.get((PaymentInfo)paymenInfo, (String)"flow_no");
        if (StringUtils.isEmpty((String)flow_no)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u6279\u6b21\u53f7flow_no\u4e3a\u7a7a\u3002", (String)"SalaryQueryPayImpl_11", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        }
        sb.append(flow_no);
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        List paymentInfos = request.getPaymentInfos();
        String responseCode = elements[0];
        if ("000000".equalsIgnoreCase(responseCode)) {
            paymentInfos = PaymentInfoService.getInstance().selectByBankBatchSeqID(((PaymentInfo)request.getPaymentInfos().get(0)).getBankBatchSeqID());
            request.setPaymentInfos(paymentInfos);
            PayStatusMatchUtil.preBatchSameItemCheck((List)paymentInfos, (boolean)false, (boolean)false);
            Map<String, BankResponse> bankResponseMap = this.getBankResult(elements);
            for (PaymentInfo info : paymentInfos) {
                String id = info.getIncomeAccNo() + info.getIncomeAccName() + info.getAmount().toString();
                BankResponse result = bankResponseMap.get(id);
                if (null == result) continue;
                this.handlePayStatus(info, result.getResponseCode(), result.getResponseMessage());
            }
            this.processingBankItemDataHandler(elements);
            PayStatusMatchUtil.backBatchSameItemHandler((List)paymentInfos, (boolean)false, (boolean)false);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_10", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private Map<String, BankResponse> getBankResult(String[] records) {
        HashMap<String, BankResponse> resultMap = new HashMap<String, BankResponse>(16);
        int length = records.length;
        int limit = length - 1;
        for (int i = this.detailIndex(); i < limit; ++i) {
            String record = records[i];
            String[] details = StringUtils.split((String)record, (String)"|");
            if (details.length < this.detailSize()) continue;
            String status = details[12];
            String statusMsg = details[13];
            BankResponse bankResponse = new BankResponse();
            bankResponse.setResponseCode(status);
            bankResponse.setResponseMessage(statusMsg);
            String key = this.getBankDataKey(details);
            resultMap.put(key, bankResponse);
        }
        return resultMap;
    }

    @Override
    public String getBankDataKey(String[] details) {
        String incomeNO = details[6];
        String incomeName = details[7];
        String incomeAmount = details[10];
        return incomeNO + incomeName + new BigDecimal(incomeAmount).setScale(2);
    }

    @Override
    public void handlePayStatus(PaymentInfo tempInfo, String[] details) {
        String status = details[12];
        String statusMsg = details[13];
        this.handlePayStatus(tempInfo, status, statusMsg);
    }

    @Override
    public int detailSize() {
        return 19;
    }

    @Override
    public int detailIndex() {
        return 8;
    }

    private void handlePayStatus(PaymentInfo tempInfo, String status, String statusMsg) {
        if ("01".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u6210\u529f", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        } else if ("09".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u5931\u8d25", (String)"SalaryQueryPayImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        } else if ("05".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u5f85\u53d1\u9001", (String)"SalaryQueryPayImpl_8", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        } else if ("06".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryQueryPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u5df2\u53d7\u7406", (String)"SalaryQueryPayImpl_9", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)tempInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryQueryPayImpl_10", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)status, (String)statusMsg);
        }
    }
}

