/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.global.service.query.b2e0007;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.global.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.global.service.Parser;
import kd.ebg.aqap.banks.boc.net.global.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    public static void parseQueryPay(List<PaymentInfo> paymentInfos, String rspStr) {
        QueryPayParser.parseQueryPay(paymentInfos.toArray(new PaymentInfo[paymentInfos.size()]), rspStr);
    }

    public static void parseQueryPay(PaymentInfo[] paymentInfos, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0007-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25\uff1a %1$s\uff0c%2$s\u3002", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]), rspcod, rspmsg));
        }
        List list = trn.getChildren("b2e0007-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String insid = rs.getChildTextTrim("insid");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((PaymentInfo[])paymentInfos, (String)BocNetUtils.getSeqIdFromInsid(insid));
            if (null == info) continue;
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("B054".equalsIgnoreCase(another_rspcod) || "B059".equalsIgnoreCase(another_rspcod) || "B002".equalsIgnoreCase(another_rspcod) || "B150".equalsIgnoreCase(another_rspcod) || "B251".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"QueryPayParser_1", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if ("B052".equalsIgnoreCase(another_rspcod) || "B030".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"QueryPayParser_2", (String)"ebg-aqap-banks-boc-net-global", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
    }
}

