/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjws.opa.services.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjws.opa.utils.AntUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element body = AntUtils.createBody();
        BankAcnt bankAcnt = (BankAcnt)bankBalanceRequest.getBankAcntList().get(0);
        JDomUtils.addChild((Element)body, (String)"partner", (String)RequestContextUtils.getBankParameterValue((String)"partner_id"));
        JDomUtils.addChild((Element)body, (String)"cardNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"queryStartDate", (String)bankBalanceRequest.getStartDate().format(this.dateFormat));
        JDomUtils.addChild((Element)body, (String)"queryEndDate", (String)bankBalanceRequest.getEndDate().format(this.dateFormat));
        JDomUtils.addChild((Element)body, (String)"cardType", (String)"");
        return AntUtils.execute(body, this.getBizCode(), Lists.newArrayList((Object[])new String[]{"cardNo", "queryStartDate", "queryEndDate"}));
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        Element response = AntUtils.getResponse(s);
        Element body = response.getChild("body");
        AntUtils.getResultInfo(body, true);
        String cardNo = JDomUtils.getChildText((Element)body, (String)"cardNo");
        String balanceInfoList = JDomUtils.getChildText((Element)body, (String)"balanceInfoList");
        balanceInfoList = new String(Base64.decodeBase64((String)balanceInfoList), StandardCharsets.UTF_8);
        JSONArray balanceInfos = JSONObject.parseArray((String)balanceInfoList);
        ArrayList responseBalance = Lists.newArrayListWithCapacity((int)4);
        for (int i = 0; i < balanceInfos.size(); ++i) {
            JSONObject obj = balanceInfos.getJSONObject(i);
            String currencyCode = obj.getString("currencyCode");
            String balance = obj.getString("balance");
            String closingAvailableBalance = obj.getString("closingAvailableBalance");
            String closingFreezeBalance = obj.getString("closingFreezeBalance");
            String balanceDate = obj.getString("balaceDate");
            if (StringUtils.isEmpty((String)balanceDate)) {
                balanceDate = obj.getString("balanceDate");
            }
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), cardNo);
            this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currencyCode);
            this.setCurrentBalance(balanceInfo, balance);
            this.setAvailableBalance(balanceInfo, closingAvailableBalance);
            this.setFreezeBalance(balanceInfo, closingFreezeBalance);
            this.setBalanceDate(balanceInfo, balanceDate, this.dateFormat);
            responseBalance.add(balanceInfo);
        }
        return new EBBankBalanceResponse((List)responseBalance);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ant.ebank.account.close.balance.query";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u65e5\u7ec8\u4f59\u989d\u67e5\u8be2", (String)"", (String)"ebg-aqap-banks-zjws-opa", (Object[])new Object[0]);
    }

    public LocalDate limitDate() {
        return null;
    }

    public int queryDays() {
        return 30;
    }

    public void configFactory(ConnectionFactory factory) {
        AntUtils.setURI(factory);
    }
}

