/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zjws.opa.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zjws.opa.utils.AntUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public int PAGE_SIZE = 50;
    public DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element body = AntUtils.createBody();
        JDomUtils.addChild((Element)body, (String)"partner", (String)RequestContextUtils.getBankParameterValue((String)"partner_id"));
        JDomUtils.addChild((Element)body, (String)"cardNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cardType", (String)"");
        JDomUtils.addChild((Element)body, (String)"timeType", (String)"01");
        String queryStartDate = bankDetailRequest.getStartDate().atStartOfDay().format(this.dateFormat);
        String queryEndDate = bankDetailRequest.getStartDate().atTime(23, 59, 59).format(this.dateFormat);
        JDomUtils.addChild((Element)body, (String)"queryStartDate", (String)queryStartDate);
        JDomUtils.addChild((Element)body, (String)"queryEndDate", (String)queryEndDate);
        JDomUtils.addChild((Element)body, (String)"pageSize", (String)String.valueOf(this.PAGE_SIZE));
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            this.setCurrentPage("1");
        }
        JDomUtils.addChild((Element)body, (String)"pageIndex", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"cashExCode", (String)"EXG");
        return AntUtils.execute(body, this.getBizCode(), Lists.newArrayList((Object[])new String[]{"cardNo", "timeType", "queryStartDate", "queryEndDate", "pageSize", "pageIndex"}));
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(8);
        Element response = AntUtils.getResponse(s);
        Element body = response.getChild("body");
        AntUtils.getResultInfo(body, true);
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        String tranHisList = JDomUtils.getChildText((Element)body, (String)"tranHisList");
        tranHisList = new String(Base64.decodeBase64((String)tranHisList), StandardCharsets.UTF_8);
        JSONArray txs = JSONObject.parseArray((String)tranHisList);
        if (!CollectionUtil.isEmpty((Collection)txs) && txs.size() == this.PAGE_SIZE) {
            this.setLastPage(false);
            int currentPage = Integer.parseInt(this.getCurrentPage());
            this.setCurrentPage(currentPage + 1);
        }
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        for (int i = 0; i < txs.size(); ++i) {
            JSONObject data = txs.getJSONObject(i);
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(bankAcnt.getAccNo());
            detailInfo.setAccName(bankAcnt.getAccName());
            String cdFlag = data.getString("tradeInOutFlag");
            BigDecimal tradeAmt = data.getBigDecimal("tradeAmt");
            String currency = bankDetailRequest.getBankCurrency();
            if ("0".equalsIgnoreCase(cdFlag)) {
                detailInfo.setCreditAmount(tradeAmt);
                detailInfo.setDebitAmount(BigDecimal.ZERO);
            } else {
                detailInfo.setDebitAmount(tradeAmt);
                detailInfo.setCreditAmount(BigDecimal.ZERO);
            }
            detailInfo.setBankDetailNo(data.getString("acSrlNo"));
            detailInfo.setPayBankDetailSeqID(data.getString("bizNo"));
            detailInfo.setOppAccNo(data.getString("oppositeCardNo"));
            detailInfo.setOppAccName(data.getString("oppositeName"));
            detailInfo.setBalance(data.getBigDecimal("balAmt"));
            String txTime = data.getString("tradeTime");
            if (StringUtils.isEmpty((String)txTime)) continue;
            if ((txTime = txTime.replaceAll("[^0-9]", "")).length() != 14) {
                logger.info("\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\uff1a{}", (Object)txTime);
                continue;
            }
            LocalDateTime dt = LocalDateTime.parse(txTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detailInfo.setTransTime(dt);
            detailInfo.setTransDate(dt.toLocalDate());
            String remark = data.getString("tradeRemark");
            detailInfo.setExplanation(remark);
            detailInfo.setCurrency(currency);
            detailInfo.setJsonMap(data.toJSONString());
            String accNo = bankDetailRequest.getAcnt().getAccNo();
            String transDateStr = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDateStr, data.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            detailInfos.add(detailInfo);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "ant.ebank.acdtl.trans.record.query";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u52a1\u660e\u7ec6\u67e5\u8be2", (String)"", (String)"ebg-aqap-banks-zjws-opa", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        AntUtils.setURI(factory);
    }
}

