/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.psbc.dc.service.payment.allocation;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.psbc.dc.Packer;
import kd.ebg.aqap.banks.psbc.dc.service.payment.PayParser;
import kd.ebg.aqap.banks.psbc.dc.service.payment.allocation.AllocationQueryPayImpl;
import kd.ebg.aqap.banks.psbc.dc.util.PackerUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AllocationPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return AllocationQueryPayImpl.class;
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u8d75\u4fca\u5cf0", (String)"AllocationPayImpl_0", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "1106";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"1.7.8 \u624b\u5de5\u5355\u7b14\u5f52\u96c6\uff081106\uff09", (String)"AllocationPayImpl_1", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u624b\u5de5\u5355\u7b14\u5f52\u96c6(1106)\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"AllocationPayImpl_2", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        if (!UseConvertor.isTransUp((PaymentInfo)paymentInfo)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e0b\u62e8\u4e1a\u52a1\u3002", (String)"AllocationPayImpl_3", (String)"ebg-aqap-banks-psbc-dc", (Object[])new Object[0]));
        }
        Element root = Packer.createReqRootElement("1106");
        Element Param = JDomUtils.addChild((Element)root, (String)"Param");
        JDomUtils.addChild((Element)Param, (String)"Pay_Account", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Param, (String)"Rec_Account", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Param, (String)"Amount", (String)PackerUtils.convertYuan2CentStr(paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Param, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)Param, (String)"EnterpriseID", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)Param, (String)"VoucherID", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Area_Code", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Usage", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)Param, (String)"Reserved1", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved2", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved3", (String)"");
        JDomUtils.addChild((Element)Param, (String)"Reserved4", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2String((Element)root, (String)encoding);
        return Packer.createCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return new PayParser().parser(request, responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

