/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.area;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.area.CMBArea;
import kd.ebg.aqap.banks.cmb.dc.area.CMBStore;
import kd.ebg.aqap.banks.cmb.dc.area.CardHandle;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class IncomeAreaMatchUtils {
    public static void matchCMBArea4Pay2SameBank(PaymentInfo paymentInfo) {
        CMBStore store = CMBStore.getInstance();
        CMBArea area = null;
        CardHandle cardHandle = store.matchCard(paymentInfo.getIncomeAccNo());
        if (null != cardHandle) {
            area = cardHandle.getCMBArea();
            if (null == area) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5361\u67c4%s\u3002", (String)"IncomeAreaMatchUtils_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), cardHandle));
            }
            paymentInfo.setIncomeProvince(area.getProvince());
            paymentInfo.setIncomeCity(area.getCity());
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
            return;
        }
        if (StringUtils.isEmpty((String)paymentInfo.getIncomeBankName()) && StringUtils.isEmpty((String)paymentInfo.getLinkpayType())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6536\u6b3e\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IncomeAreaMatchUtils_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
        }
        area = store.matchAll(paymentInfo.getIncomeCity(), paymentInfo.getIncomeProvince());
        if (null == area) {
            area = store.matchBranchBank(paymentInfo.getIncomeBankName());
        }
        if (area == null) {
            area = store.matchAll(paymentInfo.getIncomeBankAddress(), paymentInfo.getIncomeProvince());
        }
        if (null == area) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u672a\u5339\u914d\u6536\u6b3e\u5730\u533a:%s\uff0c\u8bf7\u586b\u5199\u6536\u6b3e\u5730\u533a\u7684\u884c\u653f\u89c4\u5212\u6807\u51c6\u540d\u79f0\u518d\u5c1d\u8bd5\u3002\u5982\u4ecd\u51fa\u73b0\u8be5\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u91d1\u8776\u94f6\u4f01\u4e91\u7814\u53d1\u90e8\u95e8\u3002", (String)"IncomeAreaMatchUtils_6", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), paymentInfo.getIncomeBankAddress()));
        }
        paymentInfo.setIncomeProvince(area.getProvince());
        paymentInfo.setIncomeCity(area.getCity());
        paymentInfo.setIncomeAreaCode(area.getAreaCode());
    }

    public static void matchArea4Pay2DiffBank(PaymentInfo paymentInfo) {
        CMBStore store = CMBStore.getInstance();
        CMBArea area = store.matchCity(paymentInfo.getIncomeBankAddress());
        if (null != area) {
            paymentInfo.setIncomeProvince(area.getProvince());
            paymentInfo.setIncomeCity(area.getCity());
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
            return;
        }
        area = store.matchProvince(paymentInfo.getIncomeBankAddress());
        if (null != area) {
            paymentInfo.setIncomeProvince(area.getProvince());
            paymentInfo.setIncomeCity(area.getProvince());
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
            return;
        }
        area = store.matchAll(paymentInfo.getIncomeBankName(), paymentInfo.getIncomeProvince());
        if (null != area) {
            paymentInfo.setIncomeProvince(area.getProvince());
            paymentInfo.setIncomeCity(area.getCity());
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
            return;
        }
        area = store.matchAll(paymentInfo.getIncomeBankAddress(), paymentInfo.getIncomeProvince());
        if (null != area) {
            paymentInfo.setIncomeProvince(area.getProvince());
            paymentInfo.setIncomeCity(area.getCity());
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
            return;
        }
        area = store.matchProvince(paymentInfo.getIncomeBankAddress());
        if (null != area) {
            paymentInfo.setIncomeProvince(area.getProvince());
            paymentInfo.setIncomeCity(area.getProvince());
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
            return;
        }
        if (StringUtils.isEmpty((String)paymentInfo.getIncomeProvince())) {
            paymentInfo.setIncomeProvince(paymentInfo.getIncomeBankAddress());
        }
        if (StringUtils.isEmpty((String)paymentInfo.getIncomeCity())) {
            paymentInfo.setIncomeCity(paymentInfo.getIncomeBankAddress());
        }
    }

    public static void matchCMBArea4Allocation(PaymentInfo paymentInfo) {
        CMBStore store = CMBStore.getInstance();
        CMBArea area = null;
        CardHandle cardHandle = store.matchCard(paymentInfo.getIncomeAccNo());
        if (null != cardHandle) {
            area = cardHandle.getCMBArea();
            if (null == area) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5361\u67c4%s\u3002", (String)"IncomeAreaMatchUtils_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), cardHandle));
            }
        } else {
            area = store.matchAll(paymentInfo.getIncomeCity(), paymentInfo.getIncomeProvince());
            if (area == null) {
                area = store.matchAll(paymentInfo.getIncomeBankAddress(), paymentInfo.getIncomeProvince());
            }
            if (null == area) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u4f01\u672a\u5339\u914d\u6536\u6b3e\u5730\u533a:%s\uff0c\u8bf7\u586b\u5199\u6536\u6b3e\u5730\u533a\u7684\u884c\u653f\u89c4\u5212\u6807\u51c6\u540d\u79f0\u518d\u5c1d\u8bd5\u3002\u5982\u4ecd\u51fa\u73b0\u8be5\u62a5\u9519\uff0c\u8bf7\u8054\u7cfb\u91d1\u8776\u94f6\u4f01\u4e91\u7814\u53d1\u90e8\u95e8\u3002", (String)"IncomeAreaMatchUtils_6", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), paymentInfo.getIncomeBankAddress()));
            }
        }
        paymentInfo.setIncomeProvince(area.getProvince());
        if (StringUtils.isEmpty((String)area.getBranchBankCode())) {
            CMBArea provincialCapital = store.getProvincialCapital(area);
            paymentInfo.setIncomeCity(provincialCapital.getBranchBank());
            paymentInfo.setIncomeAreaCode(provincialCapital.getBranchBankCode());
        } else {
            paymentInfo.setIncomeCity(area.getBranchBank());
            paymentInfo.setIncomeAreaCode(area.getBranchBankCode());
        }
    }
}

