/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.service.detail.CurrencyImpl;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMB_DC_Parser {
    private static Logger logger = LoggerFactory.getLogger(CMB_DC_Parser.class);

    public static BankResponse parseINFO(Element root) {
        BankResponse response = new BankResponse();
        Element info = root.getChild("INFO");
        String errorMessage = info.getChildTextTrim("ERRMSG");
        String returnCode = info.getChildTextTrim("RETCOD");
        response.setResponseCode(returnCode);
        if (StringUtils.isEmpty((String)errorMessage)) {
            response.setResponseMessage("");
        } else {
            response.setResponseMessage(errorMessage);
        }
        return response;
    }

    public static List<DetailInfo> parseDetails(BankDetailRequest rqst, String rspStr) {
        CurrencyImpl balanceImpl = new CurrencyImpl();
        BankBalanceRequest balanceRqst = new BankBalanceRequest();
        balanceRqst.setHeader(rqst.getHeader());
        balanceRqst.setBankAcntList((List)Lists.newArrayList((Object[])new BankAcnt[]{rqst.getHeader().getAcnt()}));
        EBBankBalanceResponse balanceRsp = balanceImpl.balance(balanceRqst);
        String bankCurrency = ((BalanceInfo)balanceRsp.getBalances().get(0)).getBankCurrency();
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u62db\u884c\u54cd\u5e94\u7801:%1$s;\u51fa\u9519\u539f\u56e0\u4e3a:%2$s\u3002", (String)"CMB_DC_Parser_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), headRsp.getResponseCode(), headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        List ntqtsinfzs = root.getChildren("NTQTSINFZ");
        for (int i = 0; i < ntqtsinfzs.size(); ++i) {
            Element ntqtsinfz = (Element)ntqtsinfzs.get(i);
            String dateStr = ntqtsinfz.getChildTextTrim("ETYDAT");
            String timeStr = ntqtsinfz.getChildTextTrim("ETYTIM");
            String explanation1 = ntqtsinfz.getChildTextTrim("NARYUR");
            String creditAmountStr = ntqtsinfz.getChildTextTrim("TRSAMTD");
            String debitAmountStr = ntqtsinfz.getChildTextTrim("TRSAMTC");
            String amtcdr = ntqtsinfz.getChildTextTrim("AMTCDR");
            String balanceStr = ntqtsinfz.getChildTextTrim("TRSBLV");
            String useCnStr = JDomUtils.getChildTextNullAsBlank((Element)ntqtsinfz, (String)"NUSAGE");
            String yurref = ntqtsinfz.getChildTextTrim("YURREF");
            String explanation2 = ntqtsinfz.getChildTextTrim("BUSNAR");
            String oppAccNo = ntqtsinfz.getChildTextTrim("RPYACC");
            String oppAccName = ntqtsinfz.getChildTextTrim("RPYNAM");
            String oppAccBank = ntqtsinfz.getChildTextTrim("RPYBNK");
            String groupAccNo = ntqtsinfz.getChildTextTrim("GSBACC");
            String groupAccName = ntqtsinfz.getChildTextTrim("GSBNAM");
            String refnbr = ntqtsinfz.getChildTextTrim("REFNBR");
            String trscod = ntqtsinfz.getChildTextTrim("TRSCOD");
            String trsanl = ntqtsinfz.getChildTextTrim("TRSANL");
            String businessName = ntqtsinfz.getChildTextTrim("BUSNAM");
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(bankCurrency);
            detail.setBusType(businessName);
            if (!StringUtils.isEmpty((String)debitAmountStr)) {
                detail.setCreditAmount(new BigDecimal(debitAmountStr));
                detail.setDebitAmount(ParserUtils.ZERO);
            } else if (!StringUtils.isEmpty((String)creditAmountStr)) {
                detail.setDebitAmount(new BigDecimal(creditAmountStr));
                detail.setCreditAmount(ParserUtils.ZERO);
            } else {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62db\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u91d1\u989d\u4e3a\u7a7a\uff0cTRSAMTD=\u7a7a\uff0cTRSAMTC=\u7a7a\u3002", (String)"CMB_DC_Parser_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((String)groupAccNo)) {
                detail.setOppAccNo(oppAccNo);
                detail.setOppAccName(oppAccName);
                detail.setOppBankName(oppAccBank);
            } else {
                detail.setOppAccNo(groupAccNo);
                detail.setOppAccName(groupAccName);
                detail.setOppBankName("");
            }
            if (yurref.indexOf("KD_") != -1) {
                detail.setKdFlag("KD");
                String batchNo = yurref.substring("KD_".length());
                detail.setPayBankDetailSeqID(batchNo);
            }
            if (useCnStr.indexOf("KD_") == 0) {
                detail.setKdFlag("KD");
                detail.setPayBankDetailSeqID(yurref);
                useCnStr = useCnStr.substring("KD_".length());
            }
            String string = explanation1 = StringUtils.isEmpty((String)explanation1) ? "" : explanation1;
            if (explanation1.indexOf("KD_") != -1) {
                detail.setKdFlag("KD");
                detail.setPayBankDetailSeqID(yurref);
                explanation1 = explanation1.substring("KD_".length());
            }
            String explanation = "";
            explanation = StringUtils.equals((String)explanation2, (String)explanation1) ? explanation2 : StringUtils.catWithSpace((String[])new String[]{explanation2, explanation1});
            detail.setExplanation(null == explanation ? "" : explanation);
            detail.setUseCN(useCnStr);
            LocalDateTime transTime = null;
            if (StringUtils.isEmpty((String)dateStr)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"CMB_DC_Parser_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]));
            }
            try {
                transTime = StringUtils.isEmpty((String)timeStr) ? LocalDateTime.parse(dateStr + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) : LocalDateTime.parse(dateStr + timeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f\u8f6c\u6362\u5f02\u5e38.%s\u3002", (String)"CMB_DC_Parser_6", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            detail.setTransTime(transTime);
            detail.setTransDate(LocalDate.parse(dateStr, DateTimeFormatter.BASIC_ISO_DATE));
            if (!StringUtils.isEmpty((String)balanceStr)) {
                detail.setBalance(new BigDecimal(balanceStr));
            }
            detail.setBizRefNo(refnbr);
            detail.setBankDetailNo(refnbr);
            if (!StringUtils.isEmpty((String)trscod)) {
                if ("CSTD".equalsIgnoreCase(trscod)) {
                    detail.setTransType("autotransup");
                } else if ("CSTC".equalsIgnoreCase(trscod)) {
                    detail.setTransType("autotransdown");
                }
                if (!StringUtils.isEmpty((String)trsanl) && trsanl.startsWith("ZH")) {
                    if ("C".equalsIgnoreCase(amtcdr)) {
                        detail.setTransType("autotransup");
                    } else if ("D".equalsIgnoreCase(amtcdr)) {
                        detail.setTransType("autotransdown");
                    }
                }
            }
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(ntqtsinfz);
            detail.setJsonMap(jsonStr);
            String accNo = rqst.getHeader().getAcnt().getAccNo();
            String transDate = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            detailList.add(detail);
        }
        return detailList;
    }
}

