/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CashPoolHisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    EBGLogger log = EBGLogger.getInstance().getLogger(CashPoolHisBalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        String crpseq = BankBusinessConfig.getCRPSEQ(accNo);
        String crscod = BankBusinessConfig.getCRSCOD(accNo);
        if (StringUtils.isEmpty((String)crpseq) || StringUtils.isEmpty((String)crscod)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u865a\u62df\u73b0\u91d1\u6c60\u4f59\u989d\u5931\u8d25\uff0c\u51fa\u9519\u539f\u56e0\uff1a\u534f\u8bae\u7f16\u53f7[%1$s]\u6216\u5b50\u516c\u53f8\u534f\u8bae\u5e8f\u53f7[%3$s]\u4e3a\u7a7a\u3002", (String)"CashPoolHisBalanceImpl_8", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), crscod, crpseq);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element root = CMB_DC_Packer.packRoot("SDKNTCACHST");
        Element ntaublsty = JDomUtils.addChild((Element)root, (String)"NTAUBLSTY");
        request.getStartDate();
        JDomUtils.addChild((Element)ntaublsty, (String)"BEGDAT", (String)DateTimeFormatter.ofPattern("yyyyMMdd").format(request.getStartDate()));
        JDomUtils.addChild((Element)ntaublsty, (String)"ENDDAT", (String)DateTimeFormatter.ofPattern("yyyyMMdd").format(request.getEndDate()));
        JDomUtils.addChild((Element)ntaublsty, (String)"CRPSEQ", (String)crpseq);
        JDomUtils.addChild((Element)ntaublsty, (String)"CRSCOD", (String)crscod);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO(root);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = ShowTipUtil.getResponseErrorTips((String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        List elements = root.getChildren("NTAUBLSTZ");
        ArrayList balances = new ArrayList(1);
        for (int i = 0; i < elements.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            String lmtdat = ((Element)elements.get(i)).getChildText("LMTDAT");
            String lmtamt = ((Element)elements.get(i)).getChildText("LMTAMT");
            balanceInfo.setBankAcnt(request.getAcnt());
            balanceInfo.setBankCurrency(request.getBankCurrency());
            this.setCurrentBalance(balanceInfo, lmtamt);
            this.setBalanceDateTime(balanceInfo, lmtdat + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        return new EBBankBalanceResponse(balances);
    }

    public LocalDate limitDate() {
        return LocalDate.of(1970, 1, 1);
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u8d75\u4fca\u5cf0", (String)"CashPoolHisBalanceImpl_6", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "SDKNTCACHST";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u73b0\u91d1\u6c60\u8d26\u6237\u989d\u5ea6\u5386\u53f2\u67e5\u8be2", (String)"CashPoolHisBalanceImpl_7", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }
}

