/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.jdom2.Element;

public class PaymentUtil {
    public static void addDate(Element sdkpayqyx, PaymentInfo paymentInfo) {
        String testDate = EBContext.getContext().getParameter().getBankParameter("TESTDATE");
        if (StringUtils.isEmpty((String)testDate)) {
            JDomUtils.addChild((Element)sdkpayqyx, (String)"BGNDAT", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)sdkpayqyx, (String)"ENDDAT", (String)paymentInfo.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        } else {
            JDomUtils.addChild((Element)sdkpayqyx, (String)"BGNDAT", (String)testDate);
            JDomUtils.addChild((Element)sdkpayqyx, (String)"ENDDAT", (String)testDate);
        }
    }

    public static String setBankDetailRefID(PaymentInfo paymentInfo) {
        String bankRefID = PaymentUtil.getBankDetailSeqId(paymentInfo);
        paymentInfo.setBankRefID(bankRefID);
        return bankRefID;
    }

    public static String setBankBatchRefID(PaymentInfo paymentInfo) {
        String bankRefID = PaymentUtil.getBankBatchSeqId(paymentInfo);
        paymentInfo.setBankRefID(bankRefID);
        return bankRefID;
    }

    @SdkDeprecated
    public static String getBankDetailSeqId(PaymentInfo info) {
        String bankDetailSeqID = info.getBankDetailSeqID();
        if (bankDetailSeqID.contains("KD_")) {
            return bankDetailSeqID;
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.prefix_cont((String)bankDetailSeqID);
        }
        return bankDetailSeqID;
    }

    public static String getBankDetailSeqId(String id) {
        String bankDetailSeqID = id;
        if (bankDetailSeqID.contains("KD_")) {
            return bankDetailSeqID;
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.prefix_cont((String)bankDetailSeqID);
        }
        return bankDetailSeqID;
    }

    public static String getBankBatchSeqId(PaymentInfo info) {
        String bankBatchSeqID = info.getBankBatchSeqID();
        if (bankBatchSeqID.contains("KD_")) {
            return bankBatchSeqID;
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.prefix_cont((String)bankBatchSeqID);
        }
        return bankBatchSeqID;
    }

    public static String getSeqIdFromYurref(String yurref) {
        if (yurref.contains("KD_")) {
            return yurref.substring("KD_".length());
        }
        return yurref;
    }

    public static String getYurRef(PaymentInfo info) {
        String yurRef = info.getBankRefID();
        if (StringUtils.isEmpty((String)yurRef)) {
            yurRef = PaymentUtil.getBankDetailSeqId(info);
        }
        return yurRef;
    }

    public static String getYurRefDefaultBankBatchSeqID(PaymentInfo info) {
        String yurRef = info.getBankRefID();
        if (StringUtils.isEmpty((String)yurRef)) {
            yurRef = PaymentUtil.getBankBatchSeqId(info);
        }
        return yurRef;
    }
}

