/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.area.IncomeAreaMatchUtils;
import kd.ebg.aqap.banks.cmb.dc.service.payment.agent.AgentPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.allocationtosamebank.AllocationSameBankPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.authorized.AuthorizedPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.income.IncomePayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.income.IncomeSinglePayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.SingleIndividualPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.batch.IndividualBatchPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.linkpay.LinkPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.salary.SalaryPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.salary.SingleSalaryPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.salary.batch.SalaryBatchPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) throws EBServiceException {
        this.payRoute(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    private void payRoute(PaymentInfo paymentInfo) {
        if (this.isPay_for_agentPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, AgentPayImpl.class.getName());
        } else if (this.isIncome(paymentInfo)) {
            this.setSubBizType4Income(paymentInfo);
        } else if (this.isPay_for_salary(paymentInfo)) {
            if (this.individualToDirectPay()) {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
            } else if (this.isSalary2Individual()) {
                this.setSubBizType4Individual(paymentInfo);
            } else {
                this.setSubBizType4Salary(paymentInfo);
            }
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setSubBizType4CapitalAllocation(paymentInfo);
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, LinkPayImpl.class.getName());
        } else if (this.isPay(paymentInfo)) {
            if (this.isIndividual(paymentInfo)) {
                if (this.isMerge(paymentInfo)) {
                    this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
                } else if (this.individualToDirectPay()) {
                    this.setImplClassName(paymentInfo, LinkPayImpl.class.getName());
                } else if (this.isPaymentByAuthorized()) {
                    this.authorizedPay(paymentInfo);
                } else if (this.isSalaryUseCN(paymentInfo)) {
                    if (this.isSalary2Individual()) {
                        this.setSubBizType4Individual(paymentInfo);
                    } else {
                        this.setSubBizType4Salary(paymentInfo);
                    }
                } else if (this.isDividualToDirectPay()) {
                    this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
                } else {
                    this.setSubBizType4Individual(paymentInfo);
                }
            } else if (this.isPaymentByAuthorized()) {
                this.authorizedPay(paymentInfo);
            } else if (this.isPay2DirectPay()) {
                this.setImplClassName(paymentInfo, LinkPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_18", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
        }
        if (!"pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            if (paymentInfo.is2SameBank()) {
                if (!IndividualBatchPayImpl.class.getName().equals(paymentInfo.getImplClassName())) {
                    IncomeAreaMatchUtils.matchCMBArea4Pay2SameBank(paymentInfo);
                }
            } else {
                IncomeAreaMatchUtils.matchArea4Pay2DiffBank(paymentInfo);
            }
        }
    }

    private void authorizedPay(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, AuthorizedPayImpl.class.getName());
        paymentInfo.setReversed4("payment_authorized");
    }

    private void setSubBizType4Income(PaymentInfo paymentInfo) {
        paymentInfo.setIndividual(Boolean.valueOf(true));
        if (this.isSinglePay(paymentInfo)) {
            this.setImplClassName(paymentInfo, IncomeSinglePayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, IncomePayImpl.class.getName());
        }
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo) throws EBServiceException {
        paymentInfo.setIndividual(Boolean.valueOf(true));
        if (this.isPaymentByAuthorized()) {
            this.authorizedPay(paymentInfo);
        } else if (this.isSalaryUseCN(paymentInfo)) {
            if (this.isSinglePay(paymentInfo)) {
                this.setImplClassName(paymentInfo, SingleSalaryPayImpl.class.getName());
            } else if (this.IsBathSalary()) {
                this.setImplClassName(paymentInfo, SalaryBatchPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, SalaryPayImpl.class.getName());
            }
        } else if (this.isSinglePay(paymentInfo)) {
            this.setImplClassName(paymentInfo, SingleIndividualPayImpl.class.getName());
        } else if (this.IsBathIndividual()) {
            this.setImplClassName(paymentInfo, IndividualBatchPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
        }
    }

    private void setSubBizType4Individual(PaymentInfo paymentInfo) {
        paymentInfo.setIndividual(Boolean.valueOf(true));
        if (this.isPaymentByAuthorized()) {
            this.authorizedPay(paymentInfo);
        } else if (this.isSinglePay(paymentInfo)) {
            this.setImplClassName(paymentInfo, SingleIndividualPayImpl.class.getName());
        } else if (this.IsBathIndividual()) {
            this.setImplClassName(paymentInfo, IndividualBatchPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
        }
    }

    private void setSubBizType4CapitalAllocation(PaymentInfo paymentInfo) {
        paymentInfo.setIndividual(Boolean.valueOf(false));
        if (this.isPaymentByAuthorized()) {
            this.authorizedPay(paymentInfo);
        } else if (this.isSameBank(paymentInfo)) {
            if (this.isAllocationToCompanyPay()) {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
                paymentInfo.setReversed4("AllocationToCompany");
            } else if (this.isUseAllocation()) {
                this.setImplClassName(paymentInfo, AllocationSameBankPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, AllocationPayImpl.class.getName());
                IncomeAreaMatchUtils.matchCMBArea4Allocation(paymentInfo);
            }
        } else {
            this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
        }
    }

    private boolean isPay2DirectPay() {
        return this.assertBusinessConfig("cmb_dc_isDirectPay", "true");
    }

    private boolean IsBathSalary() {
        return this.assertBusinessConfig("cmb_dc_is_Batch_salary", "true");
    }

    public boolean individualToDirectPay() {
        return this.assertBusinessConfig("cmb_dc_isDividualToDirectPay", "true");
    }

    private boolean isDividualToDirectPay() {
        return this.assertBusinessConfig("isDividualToDirectPay", "dividual_to_directpay");
    }

    private boolean isPaymentByAuthorized() {
        return this.assertBusinessConfig("cmb_dc_payment_model", "payment_authorized");
    }

    private boolean IsBathIndividual() {
        return this.assertBusinessConfig("cmb_dc_is_Batch_individual", "true");
    }

    private boolean isUseAllocation() {
        return this.assertBusinessConfig("cmb_dc_isUseAllocation", "true");
    }

    private boolean isAllocationToCompanyPay() {
        return this.assertBusinessConfig("cmb_dc_isAllocation2Company", "AllocationToCompany");
    }

    private boolean isSinglePay(PaymentInfo paymentInfo) {
        return !this.isMerge(paymentInfo) || this.assertBusinessConfig("cmb_dc_isSinglePay", "true");
    }

    private boolean isSalary2Individual() {
        return this.assertBusinessConfig("cmb_dc_isSalary2Individual", "Salary2Individual");
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u738b\u6dbf", (String)"PretreatmentImpl_16", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531\uff1a\u652f\u4ed8\u5206\u7c7b\u3002", (String)"PretreatmentImpl_17", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

