/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.individual;

import java.util.List;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_QueryPayPacker;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_QueryPayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.SingleIndividualPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SingleIndividualQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "GetAgentInfo";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getImplClassName().equalsIgnoreCase(SingleIndividualPayImpl.class.getName());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (!StringUtils.isEmpty((String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"REQNUBR"))) {
            return CMB_DC_QueryPayPacker.packQueryIndividualDetail(paymentInfos);
        }
        String buscod = "N03020";
        return CMB_DC_QueryPayPacker.packQueryIndividulPay(paymentInfos, buscod, PaymentUtil.getYurRefDefaultBankBatchSeqID(paymentInfo));
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        if (!StringUtils.isEmpty((String)PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"REQNUBR"))) {
            CMB_DC_QueryPayParser.parseQueryIndividualDetail(request.getPaymentInfos(), responseStr);
        } else {
            CMB_DC_QueryPayParser.parseQueryIndividualPay(request.getPaymentInfos(), responseStr);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml");
    }
}

