/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.payment.individual.batch;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_QueryPayPacker;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_QueryPayParser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.cmb.dc.service.payment.individual.batch.IndividualBatchPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class IndividualBatchQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1000;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.getImplClassName().equalsIgnoreCase(IndividualBatchPayImpl.class.getName());
    }

    public String getDeveloper() {
        return "hpf";
    }

    public String getBizCode() {
        return "NTAGDINF";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ee3\u53d1\u975e\u5de5\u8d44", (String)"IndividualBatchQueryPayImpl_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (!StringUtils.isEmpty((String)PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (String)"REQNUBR"))) {
            return CMB_DC_QueryPayPacker.packQueryBatchIndividualDetail(paymentInfos);
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String buscod = "N03020";
        return CMB_DC_QueryPayPacker.packQueryIndividulPay(paymentInfos, buscod, PaymentUtil.getYurRefDefaultBankBatchSeqID(paymentInfo));
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        if (!StringUtils.isEmpty((String)PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (String)"REQNUBR"))) {
            CMB_DC_QueryPayParser.parseQueryBatchIndividualDetail(paymentInfos, responseStr);
        } else {
            CMB_DC_QueryPayParser.parseQueryIndividualPay(paymentInfos, responseStr);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

