/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HistoryBalanceImpl.class);
    private static final String transCode = "QHISBAL";

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        String accType = BankAcntPropertyConfig.getAccType((String)acnt.getAccNo());
        if ("cashpool".equalsIgnoreCase(accType.trim())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5b9e\u4f53\u73b0\u91d1\u6c60\u8d26\u6237\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        String inputBankCurrency = request.getHeader().getBankCurrency();
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"AccNo", (String)accNo);
        JDomUtils.addChild((Element)in, (String)"CurrType", (String)inputBankCurrency);
        JDomUtils.addChild((Element)in, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)in, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)in, (String)"AcctSeq", (String)"");
        String encoding = EBContext.getContext().getCharsetName();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, transCode, "0.0.1.0");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding;
        String retMsg = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        Element root = JDomUtils.string2Root((String)retMsg, (String)(encoding = EBContext.getContext().getCharsetName()));
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage()));
        }
        Element out = eb.getChild("out");
        String accNo = JDomUtils.getChildText((Element)out, (String)"AccNo");
        String CurrType = JDomUtils.getChildText((Element)out, (String)"CurrType");
        List list = out.getChildren("rd");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(list.size());
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                BalanceInfo info = new BalanceInfo();
                Element rd = (Element)list.get(i);
                String balance = rd.getChildTextTrim("Amount");
                String transDate = rd.getChildTextTrim("Date");
                this.setCurrentBalance(info, balance, 100);
                if (BankBusinessConfig.qbq()) {
                    this.setAvailableBalance(info, balance, 100);
                }
                this.setBalanceDate(info, transDate, DateTimeFormatter.ISO_LOCAL_DATE);
                this.setBankCurrency(info, CurrType);
                this.setBankAcnt(info, request.getBankAcntList(), accNo);
                balances.add(info);
            }
        }
        return new EBBankBalanceResponse(balances);
    }

    public boolean match(BankBalanceRequest request) {
        return !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public LocalDate limitDate() {
        return LocalDate.of(1970, 1, 1);
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return transCode;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalanceImpl_7", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 30;
    }
}

