/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.balance.CashPoolBalanceUtil;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.CommonUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
    private static final String transCode = "QACCBAL";

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        EBBankBalanceResponse response = null;
        for (BankAcnt bankAcnt : bankAcntList) {
            try {
                request.getHeader().setAcnt(bankAcnt);
                response = this.doBiz(request);
                balanceInfos.addAll(response.getBalances());
            }
            catch (EBServiceException e) {
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(bankAcnt);
                balanceInfo.setBankCurrency(request.getBankCurrency());
                balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4eca\u65e5\u4f59\u989d\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff1a%s\u3002", (String)"TodayBalanceImpl_9", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), e.getCause()));
                balanceInfos.add(balanceInfo);
            }
        }
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getHeader().getAcnt();
        String accNo = acnt.getAccNo();
        String inputBankCurrency = request.getHeader().getBankCurrency();
        Element root = ICBC_CMP_Packer.createICBCCMPRoot(transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)"1");
        JDomUtils.addChild((Element)in, (String)"BLFlag", (String)"0");
        JDomUtils.addChild((Element)in, (String)"SynFlag", (String)"0");
        Element rd = JDomUtils.addChild((Element)in, (String)"rd");
        EBContext context = EBContext.getContext();
        String iSeqno = context.getBizSeqID();
        JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)iSeqno);
        JDomUtils.addChild((Element)rd, (String)"AccNo", (String)accNo);
        JDomUtils.addChild((Element)rd, (String)"CurrType", (String)inputBankCurrency);
        JDomUtils.addChild((Element)rd, (String)"ReqReserved3", (String)"");
        JDomUtils.addChild((Element)rd, (String)"AcctSeq", (String)"");
        String encoding = context.getCharsetName();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead(requestMessage, transCode, "0.0.1.0");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String retMsg = ICBC_CMP_Parser.decodeRsp(responseStr, true);
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsg, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        String fSeqno = pub.getChildText("fSeqno");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBalanceImpl_10", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), StrUtil.join((String)" ", (String)headRsp.getResponseCode(), (String)headRsp.getResponseMessage()));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element out = eb.getChild("out");
        List list = out.getChildren("rd");
        if (list.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5de5\u884c\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u4e0d\u542brd\u5143\u7d20", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if (list.size() == 1) {
            Element rd = (Element)list.get(0);
            String accNo = rd.getChildTextTrim("AccNo");
            String balance = rd.getChildTextTrim("Balance");
            String acctProperty = rd.getChildTextTrim("AcctProperty");
            String usableBalance = rd.getChildTextTrim("UsableBalance");
            String CurrType = rd.getChildTextTrim("CurrType");
            String accBalance = rd.getChildTextTrim("AccBalance");
            String queryTime = rd.getChildTextTrim("QueryTime");
            String iRetCode = rd.getChildTextTrim("iRetCode");
            String iRetMsg = rd.getChildTextTrim("iRetMsg");
            String freezeBal = rd.getChildTextTrim("FrzAmt");
            ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
            BalanceInfo info = new BalanceInfo();
            balances.add(info);
            this.setCurrentBalance(info, balance, 100);
            if (!StrUtil.isEmpty((String)accBalance)) {
                logger.info("\u89e3\u6790\u5230\u5de5\u884c\u8fd4\u56de\u7684'\u4e0a\u65e5\u4f59\u989d'\u4e3a" + accBalance + "\u5206");
                info.setLastDayAvlBalance(ParserUtils.convertCentStr2Yuan((String)accBalance));
            }
            if (!StrUtil.isEmpty((String)usableBalance)) {
                logger.info("\u89e3\u6790\u5230\u5de5\u884c\u8fd4\u56de\u7684'\u53ef\u7528\u4f59\u989d'\u4e3a" + usableBalance + "\u5206");
                info.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)usableBalance));
            }
            if (StringUtils.isNotEmpty((String)freezeBal)) {
                info.setFreezeBalance(ParserUtils.convertCentStr2Yuan((String)freezeBal));
            }
            info.setBankCurrency(CurrType);
            if (CommonUtils.isCashPoolAcnt(accNo)) {
                CashPoolBalanceUtil.queryAvailableBalance(info, accNo);
            }
            BankAcnt bankAcnt = new BankAcnt();
            info.setBankAcnt(bankAcnt);
            info.setBalanceDateTime(LocalDateTime.now());
            bankAcnt.setAccNo(accNo);
            return new EBBankBalanceResponse(balances);
        }
        String errorMsg = ResManager.loadKDString((String)"\u5de5\u884c\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\u5185\u5bb9\u9519\u8bef,\u91d1\u8776\u7684\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u53ea\u652f\u6301\u5355\u7b14,\u5374\u8fd4\u56de\u4e86\u591a\u7b14", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
        throw EBExceiptionUtil.serviceException((String)errorMsg);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return transCode;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u300a\u591a\u8d26\u6237\u4f59\u989d\u67e5\u8be2.xls\u300b;\u4ea4\u6613\u7801\u662f'QACCBAL'", (String)"TodayBalanceImpl_8", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }
}

