/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.individual;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_PayParser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.individual.PAYPERIndividualQueryPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.CommonUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PAYPERIndividualPayImpl
extends AbstractPayImpl
implements IPay {
    private static final String transCode = "PAYPER";

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 150;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return PAYPERIndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return transCode;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u79c1\u652f\u4ed8/\u4ee3\u53d1\uff0c\u5c3d\u91cf\u5e76\u7b14\u5165\u8d26\u3002", (String)"PAYPERIndividualPayImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !(!"pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.getIndividual() == false || BankBusinessConfig.isUseZipInterface() || !BankBusinessConfig.isFinance() && paymentInfo.getMerge() != false);
    }

    public String pack(BankPayRequest request) {
        BigDecimal totalAmt = new BigDecimal("0.00");
        List paymentInfos = request.getPaymentInfos();
        Element root = ICBC_CMP_Packer.createICBCCMPRootForPay(transCode, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"OnlBatF", (String)"1");
        if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue() && ((PaymentInfo)paymentInfos.get(0)).getSameBank().booleanValue()) {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"2");
        } else {
            JDomUtils.addChild((Element)in, (String)"SettleMode", (String)"0");
        }
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)("" + paymentInfos.size()));
        JDomUtils.addChild((Element)in, (String)"TotalAmt", (String)"");
        String signDate4Test = EBContext.getContext().getParameter().getBankParameter("signDate4Test");
        boolean isProduct = StrUtil.isEmpty((String)signDate4Test);
        if (isProduct) {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        } else {
            JDomUtils.addChild((Element)in, (String)"SignTime", (String)(signDate4Test + LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS"))));
        }
        JDomUtils.addChild((Element)in, (String)"ReqReserved1", (String)"");
        JDomUtils.addChild((Element)in, (String)"ReqReserved2", (String)"");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            Element rd = JDomUtils.addChild((Element)in, (String)"rd");
            JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)((PaymentInfo)paymentInfos.get(i)).getBankSerialNo());
            JDomUtils.addChild((Element)rd, (String)"ReimburseNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReimburseNum", (String)"");
            if (isProduct && null != ((PaymentInfo)paymentInfos.get(i)).getBookingTime() && ((PaymentInfo)paymentInfos.get(i)).getBookingTime().isAfter(LocalDateTime.now())) {
                JDomUtils.addChild((Element)rd, (String)"StartDate", (String)((PaymentInfo)paymentInfos.get(i)).getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                JDomUtils.addChild((Element)rd, (String)"StartTime", (String)((PaymentInfo)paymentInfos.get(i)).getBookingTime().format(DateTimeFormatter.ofPattern("HHmmss")));
                PaymentUtil.setBookPayFlag((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            } else {
                JDomUtils.addChild((Element)rd, (String)"StartDate", (String)"");
                JDomUtils.addChild((Element)rd, (String)"StartTime", (String)"");
            }
            JDomUtils.addChild((Element)rd, (String)"PayType", (String)(((PaymentInfo)paymentInfos.get(i)).getUrgent() != false ? "1" : "2"));
            JDomUtils.addChild((Element)rd, (String)"PayAccNo", (String)((PaymentInfo)paymentInfos.get(i)).getAccNo());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameCN", (String)((PaymentInfo)paymentInfos.get(i)).getAccName());
            JDomUtils.addChild((Element)rd, (String)"PayAccNameEN", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecAccNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameCN", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeAccName());
            JDomUtils.addChild((Element)rd, (String)"RecAccNameEN", (String)"");
            if (!((PaymentInfo)paymentInfos.get(i)).getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"2");
            } else {
                JDomUtils.addChild((Element)rd, (String)"SysIOFlg", (String)"1");
            }
            JDomUtils.addChild((Element)rd, (String)"IsSameCity", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecICBCCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"RecCityName", (String)CommonUtils.substringChinese(StrUtil.trim((CharSequence)((PaymentInfo)paymentInfos.get(i)).getIncomeBankAddress()), 40));
            JDomUtils.addChild((Element)rd, (String)"RecBankNo", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeCnaps());
            JDomUtils.addChild((Element)rd, (String)"RecBankName", (String)((PaymentInfo)paymentInfos.get(i)).getIncomeBankName());
            JDomUtils.addChild((Element)rd, (String)"CurrType", (String)((PaymentInfo)paymentInfos.get(i)).getCurrency());
            JDomUtils.addChild((Element)rd, (String)"PayAmt", (String)PackerUtils.convertYuan2CentStr((BigDecimal)((PaymentInfo)paymentInfos.get(i)).getAmount()));
            JDomUtils.addChild((Element)rd, (String)"UseCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"UseCN", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation().substring(0, Math.min(10, ((PaymentInfo)paymentInfos.get(i)).getExplanation().length())));
            JDomUtils.addChild((Element)rd, (String)"EnSummary", (String)"");
            if (CommonUtils.purposeOrSummary("3")) {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)"");
            } else if (BankBusinessConfig.isPostScriptIntercept()) {
                String PostScript = "";
                PostScript = !((PaymentInfo)paymentInfos.get(i)).is2SameBank() ? CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 60) : CommonUtils.substringChinese(StringUtils.trim((String)((PaymentInfo)paymentInfos.get(i)).getExplanation()), 100);
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)PostScript);
            } else {
                JDomUtils.addChild((Element)rd, (String)"PostScript", (String)((PaymentInfo)paymentInfos.get(i)).getExplanation());
            }
            String Summary = ((PaymentInfo)paymentInfos.get(i)).getExplanation();
            Summary = CommonUtils.substringChinese(StrUtil.trim((CharSequence)Summary), 20);
            JDomUtils.addChild((Element)rd, (String)"Summary", (String)(CommonUtils.purposeOrSummary("2") ? "" : Summary));
            if (((PaymentInfo)paymentInfos.get(0)).getMerge().booleanValue() && ((PaymentInfo)paymentInfos.get(0)).getSameBank().booleanValue()) {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankBatchSeqId()));
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            } else {
                JDomUtils.addChild((Element)rd, (String)"Ref", (String)ICBC_CMP_PayParser.getRef(((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqId()));
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(i)));
            }
            JDomUtils.addChild((Element)rd, (String)"Oref", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPSqn", (String)((PaymentInfo)paymentInfos.get(i)).getBankDetailSeqID());
            JDomUtils.addChild((Element)rd, (String)"BusCode", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ERPcheckno", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhType", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhName", (String)"");
            JDomUtils.addChild((Element)rd, (String)"CrvouhNo", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReqReserved3", (String)"");
            JDomUtils.addChild((Element)rd, (String)"ReqReserved4", (String)"");
        }
        in.getChild("TotalAmt").setText(PackerUtils.convertYuan2CentStr((BigDecimal)totalAmt));
        String encoding = EBContext.getContext().getCharsetName();
        String reqstMsg = JDomUtils.root2String((Element)root, (String)encoding);
        String msgSigned = ICBC_CMP_Packer.sign(reqstMsg, request.getPaymentInfos());
        return ICBC_CMP_Packer.createMessageWithHeadForPay(msgSigned, this.getBizCode(), "0.0.0.1", 0, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        ICBC_CMP_PayParser.parsePay(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

