/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment.reservefund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_QueryPayPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryReserveFundPayment
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryReserveFundPayment.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return ICBC_CMP_QueryPayPacker.packQueryPayNew(bankPayRequest.getPaymentInfos(), this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        this.parseQueryPay(bankPayRequest.getPaymentInfos(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "QDJGSHK";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5907\u7528\u91d1\u67e5\u8be2\u63a5\u53e3", (String)"QueryReserveFundPayment_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public void parseQueryPay(List<PaymentInfo> paymentInfos, String rspStr) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        EBContext context = EBContext.getContext();
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        String bankStatus = "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        String bankMsg = headRsp.getResponseMessage();
        if ("A0001".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ICBC_CMP_QueryPayParser_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
            return;
        }
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u62a5\u6587\u5934\u8fd4\u56de\u9519\u8bef\u7801\u65e0\u6cd5\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"ICBC_CMP_QueryPayParser_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
            return;
        }
        Element out = eb.getChild("out");
        List list = out.getChildren("rd");
        this.parseQueryPayRd(paymentInfos, list);
    }

    private void parseQueryPayRd(List<PaymentInfo> paymentInfos, List<Element> list) {
        PaymentInfo info = paymentInfos.get(0);
        for (Element rd : list) {
            PaymentInfo paymentInfo;
            String iSeqno = rd.getChildTextTrim("iSeqno");
            String iRetCode = rd.getChildTextTrim("iRetCode");
            String iRetMsg = rd.getChildTextTrim("iRetMsg");
            String result = rd.getChildText("Result");
            String recAccount = rd.getChildText("RecAccount");
            String acctName = rd.getChildText("RecAcctName");
            String amount = rd.getChildText("Amount");
            if (StringUtils.isNotEmpty((String)amount)) {
                try {
                    amount = new BigDecimal(amount).divide(new BigDecimal(100), 2, RoundingMode.DOWN).toPlainString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (null == (paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)info.getBankBatchSeqID(), (String)iSeqno))) {
                this.logger.info("\u672a\u627e\u5230{}\u5bf9\u5e94\u7684\u4ed8\u6b3e", (Object)iSeqno);
                continue;
            }
            if ("7".equalsIgnoreCase(result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)result, (String)iRetMsg);
            } else if ("6".equalsIgnoreCase(result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)iRetCode, (String)iRetMsg);
            } else if ("0".equalsIgnoreCase(result) || "9".equals(result)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)iRetCode, (String)iRetMsg);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)iRetCode, (String)iRetMsg);
            }
            CommonPayStatusMatchUtil.checkPayStatusWith3Factor((PaymentInfo)paymentInfo, (String)recAccount, (String)acctName, (String)amount, (boolean)BankBusinessConfig.isUseCheckWith3Factor());
        }
    }
}

