/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.utils;

import java.io.UnsupportedEncodingException;
import java.util.List;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.utils.string.StrUtil;

public class CommonUtils {
    public static String substringChinese(String srcStr, int maxByteLength) {
        if (StrUtil.isEmpty((String)srcStr)) {
            return "";
        }
        if (srcStr.length() * 2 <= maxByteLength) {
            return srcStr;
        }
        char[] srcChrs = srcStr.toCharArray();
        int totalLength = 0;
        StringBuilder retStr = new StringBuilder();
        for (char chr : srcChrs) {
            try {
                totalLength += String.valueOf(chr).getBytes("GBK").length;
            }
            catch (UnsupportedEncodingException e) {
                totalLength += chr > '\u00ff' ? 2 : 1;
            }
            if (totalLength > maxByteLength) break;
            retStr.append(chr);
        }
        return retStr.toString();
    }

    public static boolean isCashPoolAcnt(String accNo) {
        String acntType = BankAcntPropertyConfig.getAccType((String)accNo);
        if (StrUtil.isEmpty((String)acntType)) {
            return false;
        }
        return "cashpool".equalsIgnoreCase(acntType.trim());
    }

    public static boolean isInner2Outer(String incomeAccNo) {
        List<String> fundAccountPool = BankBusinessConfig.getFundAccountPool();
        for (String fundAccount : fundAccountPool) {
            if (!incomeAccNo.equalsIgnoreCase(fundAccount)) continue;
            return true;
        }
        return false;
    }

    public static boolean purposeOrSummary(String condition) {
        String obj = BankBusinessConfig.popResult();
        return obj.equalsIgnoreCase(condition);
    }
}

