/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        Element root = Packer.createRootNode();
        String transCode = "0001";
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            transCode = "0054";
        }
        Element message = Packer.createMessageNode(root, transCode, Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"account", (String)request.getAcnt().getAccNo());
        String root2String = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        return root2String;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element message = JDomUtils.getChildElement((Element)root, (String)"Message");
        Element commHead = JDomUtils.getChildElement((Element)message, (String)"commHead");
        String retCode = JDomUtils.getChildText((Element)commHead, (String)"retCode");
        Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
        if ("000".equalsIgnoreCase(retCode)) {
            if (null == body) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de body \u4e3a\u7a7a\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
            }
            if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
                return this.parseFixedBalance(request, body);
            }
            String account = JDomUtils.getChildText((Element)body, (String)"account");
            String balSign = JDomUtils.getChildText((Element)body, (String)"balSign");
            String balance = JDomUtils.getChildText((Element)body, (String)"balance");
            String freeze = JDomUtils.getChildText((Element)body, (String)"freeze");
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, request.getBankAcntList(), account);
            BigDecimal bal = new BigDecimal("0.00");
            if (!StringUtils.isEmpty((String)balSign)) {
                balanceInfo.setAvailableBalance(new BigDecimal(balSign + balance));
                bal = bal.add(new BigDecimal(balSign + balance));
            } else {
                balanceInfo.setAvailableBalance(new BigDecimal(balance));
                bal = bal.add(new BigDecimal(balance));
            }
            if (!StringUtils.isEmpty((String)freeze)) {
                bal = bal.add(new BigDecimal(freeze));
            }
            balanceInfo.setCurrentBalance(bal);
            balanceInfo.setBankCurrency(request.getBankCurrency());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
            bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
            return bankBalanceResponse;
        }
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)retCode, (String)""));
    }

    public EBBankBalanceResponse parseFixedBalance(BankBalanceRequest request, Element body) {
        BankAcnt bankAcnt = request.getAcnt();
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(bankAcnt);
        BigDecimal bal = new BigDecimal("0.00");
        String totalCount = JDomUtils.getChildText((Element)body, (String)"totalCount");
        String bankCurrency = request.getBankCurrency();
        Element records = JDomUtils.getChildElement((Element)body, (String)"records");
        if (records == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u4f59\u989d\u8bb0\u5f55\u3002", (String)"BalanceImpl_5", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
        }
        List recordList = records.getChildren("record");
        BigDecimal totalAvailableBalance = new BigDecimal("0.00");
        BigDecimal totalBalance = new BigDecimal("0.00");
        if (recordList != null && recordList.size() > 0) {
            for (Element record : recordList) {
                String currency = JDomUtils.getChildText((Element)record, (String)"currencyType");
                String balanceStr = JDomUtils.getChildText((Element)record, (String)"balance");
                String okBalanceStr = JDomUtils.getChildText((Element)record, (String)"okBalance");
                String badBalance = JDomUtils.getChildText((Element)record, (String)"badBalance");
                if (!bankCurrency.equalsIgnoreCase(currency)) continue;
                if (StringUtils.isNotEmpty((String)balanceStr)) {
                    BigDecimal balance = new BigDecimal(balanceStr);
                    totalBalance = totalBalance.add(balance);
                }
                if (!StringUtils.isNotEmpty((String)balanceStr)) continue;
                BigDecimal availableBalance = new BigDecimal(okBalanceStr);
                totalAvailableBalance = totalAvailableBalance.add(availableBalance);
            }
        }
        if (totalAvailableBalance.compareTo(BigDecimal.ZERO) != 0) {
            balanceInfo.setAvailableBalance(totalAvailableBalance);
        }
        if (totalBalance.compareTo(BigDecimal.ZERO) != 0) {
            balanceInfo.setCurrentBalance(totalBalance);
        }
        balanceInfo.setBankCurrency(bankCurrency);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return bankBalanceResponse;
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "0001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        return this.doBiz(request);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public boolean isForm() {
        String exchangeProtocol = RequestContextUtils.getExchangeProtocol();
        return "http".equalsIgnoreCase(exchangeProtocol);
    }

    public String getFormKey() {
        return "cgb_data";
    }
}

