/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.service.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gdb.dc.service.detail.DetailPage;
import kd.ebg.aqap.banks.gdb.dc.util.KDUtil;
import kd.ebg.aqap.banks.gdb.dc.util.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPageImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailPageImpl.class);

    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.isDetailWithPage();
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = Packer.createRootNode();
        Element message = Packer.createMessageNode(root, "0132", Packer.getSeqNo());
        Element body = JDomUtils.addChild((Element)message, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"account", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"beginDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"queryType", (String)"0");
        String pageTag = this.getCurrentPage();
        if (!StringUtils.isEmpty((String)pageTag)) {
            String[] strs = pageTag.split("-");
            JDomUtils.addChild((Element)body, (String)"beginRecTranDate", (String)strs[0]);
            JDomUtils.addChild((Element)body, (String)"beginRecTranCode", (String)strs[1]);
            JDomUtils.addChild((Element)body, (String)"beginRecTranSeq", (String)strs[2]);
        }
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"1000");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        ArrayList<DetailInfo> result = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element message = JDomUtils.getChildElement((Element)root, (String)"Message");
        Element commHead = JDomUtils.getChildElement((Element)message, (String)"commHead");
        String retCode = JDomUtils.getChildText((Element)commHead, (String)"retCode");
        Element body = JDomUtils.getChildElement((Element)message, (String)"Body");
        this.logger.info("retCode:" + retCode);
        String pageTagNext = DetailPage.getNextPageTag(responseStr);
        this.setCurrentPage(pageTagNext);
        boolean lastPage = DetailPage.isLastPage(responseStr);
        this.setLastPage(lastPage);
        if ("000".equalsIgnoreCase(retCode)) {
            if (null != body) {
                String account = JDomUtils.getChildText((Element)body, (String)"account");
                String totalNum = JDomUtils.getChildText((Element)body, (String)"totalNum");
                this.logger.info("totalNum:" + totalNum);
                BankAcnt bankAcnt = bankDetailRequest.getAcnt();
                if (!bankAcnt.getAccNo().equals(account)) {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7(%1$s)\u4e0e\u8fd4\u56de\u8d26\u53f7(%2$s)\u4e0d\u4e00\u81f4\uff1b", (String)"DetailPageImpl_8", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), bankAcnt.getAccNo(), account));
                }
                Element records = JDomUtils.getChildElement((Element)body, (String)"records");
                if (records == null) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u4f59\u989d\u8bb0\u5f55\u3002", (String)"DetailPageImpl_3", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
                }
                List recordList = records.getChildren("record");
                HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
                if (recordList != null && recordList.size() > 0) {
                    for (Element record : recordList) {
                        String bankDetailSeqId;
                        String serialNo = JDomUtils.getChildText((Element)record, (String)"serialNo");
                        String dealDate = JDomUtils.getChildText((Element)record, (String)"dealDate");
                        String loanSign = JDomUtils.getChildText((Element)record, (String)"loanSign");
                        String dealMoney = JDomUtils.getChildText((Element)record, (String)"dealMoney");
                        String financingSymbol = JDomUtils.getChildText((Element)record, (String)"financingSymbol");
                        String usableMoney = JDomUtils.getChildText((Element)record, (String)"usableMoney");
                        String abstractStr = JDomUtils.getChildText((Element)record, (String)"abstract");
                        String absCode = JDomUtils.getChildText((Element)record, (String)"absCode");
                        String oppoAccno = JDomUtils.getChildText((Element)record, (String)"oppoAccno");
                        String name = JDomUtils.getChildText((Element)record, (String)"name");
                        String dealTime = JDomUtils.getChildText((Element)record, (String)"dealTime");
                        String abstractContent = JDomUtils.getChildText((Element)record, (String)"abstractContent");
                        String summary = JDomUtils.getChildText((Element)record, (String)"summary");
                        String postScript = JDomUtils.getChildText((Element)record, (String)"postScript");
                        String reserve2 = JDomUtils.getChildText((Element)record, (String)"reserve2");
                        String uniqueCode = JDomUtils.getChildText((Element)record, (String)"uniqueCode");
                        DetailInfo detailInfo = new DetailInfo();
                        detailInfo.setAccNo(bankAcnt.getAccNo());
                        detailInfo.setAccName(bankAcnt.getAccName());
                        detailInfo.setBankName(bankAcnt.getBankName());
                        detailInfo.setOppAccNo(oppoAccno);
                        detailInfo.setOppAccName(name);
                        String reserve6 = JDomUtils.getChildText((Element)record, (String)"reserve6");
                        detailInfo.setOppBankName(reserve6);
                        detailInfo.setCurrency(bankDetailRequest.getHeader().getBankCurrency());
                        if ("+".equalsIgnoreCase(loanSign)) {
                            if ("-".equalsIgnoreCase(financingSymbol)) {
                                detailInfo.setCreditAmount(new BigDecimal(dealMoney).multiply(new BigDecimal(-1)));
                            } else {
                                detailInfo.setCreditAmount(new BigDecimal(dealMoney));
                            }
                            detailInfo.setDebitAmount(new BigDecimal("0.00"));
                        }
                        if ("-".equalsIgnoreCase(loanSign)) {
                            if ("-".equalsIgnoreCase(financingSymbol)) {
                                detailInfo.setDebitAmount(new BigDecimal(dealMoney).multiply(new BigDecimal(-1)));
                            } else {
                                detailInfo.setDebitAmount(new BigDecimal(dealMoney));
                            }
                            detailInfo.setCreditAmount(new BigDecimal("0.00"));
                        }
                        if (!StringUtils.isEmpty((String)dealDate)) {
                            detailInfo.setTransDate(LocalDate.parse(dealDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                            try {
                                if (!StringUtils.isEmpty((String)dealTime)) {
                                    detailInfo.setTransTime(LocalDateTime.parse(dealDate + dealTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                                }
                                detailInfo.setTransTime(LocalDateTime.parse(dealDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                            }
                            catch (DateTimeParseException e) {
                                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38\uff1a", (String)"DetailPageImpl_4", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), (Throwable)e);
                            }
                        } else {
                            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"DetailPageImpl_5", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]));
                        }
                        if (!StringUtils.isEmpty((String)usableMoney)) {
                            detailInfo.setBalance(new BigDecimal(usableMoney));
                        }
                        if (StringUtils.isEmpty((String)(bankDetailSeqId = KDUtil.getBankDetailSeqIdFromStr(postScript)))) {
                            bankDetailSeqId = KDUtil.getBankDetailSeqIdFromStr(summary);
                            if (StringUtils.isEmpty((String)bankDetailSeqId)) {
                                bankDetailSeqId = KDUtil.getBankDetailSeqIdFromStr(abstractContent);
                            } else {
                                summary = KDUtil.cutKDFlag(summary);
                            }
                        } else {
                            postScript = KDUtil.cutKDFlag(postScript);
                        }
                        if (!StringUtils.isEmpty((String)bankDetailSeqId)) {
                            DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)bankDetailSeqId);
                            detailInfo.setKdFlag(bankDetailSeqId);
                            detailInfo.setPayBankDetailSeqID(bankDetailSeqId);
                        }
                        if (!StringUtils.isEmpty((String)postScript)) {
                            if (!StringUtils.isEmpty((String)summary)) {
                                detailInfo.setExplanation(postScript + "-" + summary);
                            } else {
                                detailInfo.setExplanation(postScript);
                            }
                        } else {
                            detailInfo.setExplanation(summary);
                        }
                        if (PropertiesConstants.getValue((String)"TRANSFER_DOWN").equalsIgnoreCase(abstractStr) || "X15".equals(absCode)) {
                            detailInfo.markTransDown();
                        } else if (PropertiesConstants.getValue((String)"TRANSFER_UP").equalsIgnoreCase(abstractStr) || "GTV".equals(absCode)) {
                            detailInfo.markTransUp();
                        }
                        detailInfo.setBankDetailNo(uniqueCode);
                        String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                        JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                        jsonObject.put("reserve2", (Object)uniqueCode);
                        detailInfo.setJsonMap(jsonObject.toJSONString());
                        String accNo = bankAcnt.getAccNo();
                        String transDate = LocalDateUtil.formatDate((LocalDate)detailInfo.getTransDate());
                        String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
                        if (countMap.containsKey(receiptNo)) {
                            int count = (Integer)countMap.get(receiptNo) + 1;
                            countMap.put(receiptNo, count);
                            receiptNo = receiptNo + "-" + String.format("%04d", count);
                        } else {
                            countMap.put(receiptNo, 0);
                        }
                        detailInfo.setReceiptNo(receiptNo);
                        result.add(detailInfo);
                    }
                }
            } else {
                this.logger.info("\u94f6\u884c\u8fd4\u56de body \u4e3a\u7a7a");
            }
        } else {
            if ("251".equals(retCode)) {
                this.logger.info("\u67e5\u8be2\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801251, \u6b64\u6bb5\u65f6\u95f4\u5185\u65e0\u4ea4\u6613.");
                return new EBBankDetailResponse(result);
            }
            if ("242".equals(retCode)) {
                this.logger.info("\u67e5\u8be2\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u54cd\u5e94\u7801242, \u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4ea4\u6613\u8bb0\u5f55.");
                return new EBBankDetailResponse(result);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801:%s\u3002", (String)"DetailPageImpl_9", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]), retCode));
        }
        return new EBBankDetailResponse(result);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "0132";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5206\u9875\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u3002", (String)"DetailPageImpl_7", (String)"ebg-aqap-banks-gdb-dc", (Object[])new Object[0]);
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(100);
        String pageTag = DetailPage.getFirstPageTag();
        this.setCurrentPage(pageTag);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse ebBankDetailResponse = this.doBiz(request);
            this.logger.info("details\u7684\u6570\u91cf{}", (Object)ebBankDetailResponse.getDetails().size());
            if (ebBankDetailResponse == null || CollectionUtils.isEmpty((Collection)ebBankDetailResponse.getDetails())) continue;
            detailInfos.addAll(ebBankDetailResponse.getDetails());
        }
        this.logger.info("\u5206\u9875\u67e5\u8be2\u7ed3\u675f,\u603b\u7684detailInfos\u7684\u6570\u91cf{}", (Object)detailInfos.size());
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }
}

