/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cqb.dc.services;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cqb.dc.services.Signature;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CQB_DC_Packer {
    public static String createDetailMessage(BankDetailRequest bankDetailRequest) {
        LocalDate startDate = bankDetailRequest.getStartDate();
        LocalDate endDate = bankDetailRequest.getEndDate();
        if (endDate.toEpochDay() - startDate.toEpochDay() > 30L) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5f00\u59cb\u65e5\u671f\u4e0e\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc730\u5929\u3002", (String)"CQB_DC_Packer_0", (String)"ebg-aqap-banks-cqb-dc", (Object[])new Object[0]));
        }
        Element in = new Element("in");
        Element head = CQB_DC_Packer.createCommonHead("4404");
        Element body = new Element("body");
        Element trans = new Element("trans");
        JDomUtils.addChild((Element)body, (Element)trans);
        JDomUtils.addChild((Element)trans, (String)"AccountNo", (String)bankDetailRequest.getAcnt().getAccNo());
        String testTime = RequestContextUtils.getBankParameterValue((String)"TEST_TIME");
        if (StringUtils.isNotEmpty((String)testTime)) {
            JDomUtils.addChild((Element)trans, (String)"BgnDate", (String)testTime);
            JDomUtils.addChild((Element)trans, (String)"EndDate", (String)testTime);
        } else {
            JDomUtils.addChild((Element)trans, (String)"BgnDate", (String)startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)trans, (String)"EndDate", (String)endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        JDomUtils.addChild((Element)in, (Element)head);
        JDomUtils.addChild((Element)in, (Element)Signature.getInstance().sign(body));
        return JDomUtils.root2String((Element)in, (String)RequestContextUtils.getCharset());
    }

    public static String createBalanceMessage(String accNo) {
        Element in = new Element("in");
        Element head = CQB_DC_Packer.createCommonHead("4402");
        Element body = new Element("body");
        Element trans = new Element("trans");
        JDomUtils.addChild((Element)body, (Element)trans);
        JDomUtils.addChild((Element)trans, (String)"AccountNo", (String)accNo);
        JDomUtils.addChild((Element)in, (Element)head);
        JDomUtils.addChild((Element)in, (Element)Signature.getInstance().sign(body));
        return JDomUtils.root2String((Element)in, (String)RequestContextUtils.getCharset());
    }

    public static Element createCommonHead(String transCode) {
        Date date = new Date();
        long time = date.getTime();
        String dateline = time + "";
        String PacketId = dateline.substring(0, 10);
        Element element = new Element("head");
        JDomUtils.addChild((Element)element, (String)"TransCode", (String)transCode);
        JDomUtils.addChild((Element)element, (String)"TransDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)element, (String)"TransTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        String CorpNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        JDomUtils.addChild((Element)element, (String)"MasterId", (String)CorpNo);
        JDomUtils.addChild((Element)element, (String)"PacketId", (String)PacketId);
        return element;
    }

    public static String packBatchPay(BankPayRequest bankPayRequest) {
        Element in = new Element("in");
        Element head = CQB_DC_Packer.createCommonHead("4409");
        Element body = new Element("body");
        Element trans = new Element("trans");
        JDomUtils.addChild((Element)body, (Element)trans);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JDomUtils.addChild((Element)trans, (String)"FromAcctNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)trans, (String)"FromAcctName", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)trans, (String)"OrderId", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID());
        JDomUtils.addChild((Element)trans, (String)"TotalCount", (String)(paymentInfos.size() + ""));
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            total = total.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
        }
        JDomUtils.addChild((Element)trans, (String)"TotalAmount", (String)total.toString());
        Element List2 = new Element("List");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(i);
            Element transferInfo = new Element("TransferInfo");
            JDomUtils.addChild((Element)transferInfo, (String)"ToAcctNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)transferInfo, (String)"ToAcctName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)transferInfo, (String)"TransStyle", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
            JDomUtils.addChild((Element)transferInfo, (String)"ToBankCode", (String)paymentInfo.getIncomeCnaps());
            JDomUtils.addChild((Element)transferInfo, (String)"Amount", (String)paymentInfo.getAmount().toString());
            JDomUtils.addChild((Element)transferInfo, (String)"Summary", (String)paymentInfo.getExplanation());
            JDomUtils.addChild((Element)List2, (Element)transferInfo);
        }
        JDomUtils.addChild((Element)trans, (Element)List2);
        JDomUtils.addChild((Element)in, (Element)head);
        JDomUtils.addChild((Element)in, (Element)Signature.getInstance().sign(body));
        return JDomUtils.root2String((Element)in, (String)RequestContextUtils.getCharset());
    }

    public static String packQueryBatchPay(BankPayRequest bankPayRequest) {
        Element in = new Element("in");
        Element head = CQB_DC_Packer.createCommonHead("4407");
        Element body = new Element("body");
        Element trans = new Element("trans");
        JDomUtils.addChild((Element)body, (Element)trans);
        JDomUtils.addChild((Element)trans, (String)"OrderId", (String)bankPayRequest.getBankBatchSeqID());
        JDomUtils.addChild((Element)in, (Element)head);
        JDomUtils.addChild((Element)in, (Element)Signature.getInstance().sign(body));
        return JDomUtils.root2String((Element)in, (String)RequestContextUtils.getCharset());
    }
}

